/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import java.util.List;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.PagingBean;
import org.seasar.robot.dbflute.cbean.PagingHandler;
import org.seasar.robot.dbflute.cbean.PagingResultBean;
import org.seasar.robot.dbflute.cbean.ResultBeanBuilder;
import org.seasar.robot.dbflute.exception.DangerousResultSizeException;
import org.seasar.robot.dbflute.exception.PagingStatusInvalidException;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingInvoker<ENTITY> {
    protected String _tableDbName;

    public PagingInvoker(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagingResultBean<ENTITY> invokePaging(PagingHandler<ENTITY> handler) {
        this.assertObjectNotNull("handler", handler);
        PagingBean pagingBean = handler.getPagingBean();
        this.assertObjectNotNull("handler.getPagingBean()", pagingBean);
        if (!pagingBean.isFetchScopeEffective()) {
            this.throwPagingStatusInvalidException(pagingBean);
        }
        int safetyMaxResultSize = pagingBean.getSafetyMaxResultSize();
        ResultBeanBuilder<ENTITY> builder = this.createResultBeanBuilder();
        try {
            int allRecordCount;
            List<ENTITY> selectedList;
            if (pagingBean.isCountLater()) {
                selectedList = handler.paging();
                allRecordCount = this.isCurrentLastPage(selectedList, pagingBean) ? this.deriveAllRecordCountFromLastPageValues(selectedList, pagingBean) : handler.count();
                this.checkSafetyResultIfNeed(safetyMaxResultSize, allRecordCount);
            } else {
                allRecordCount = handler.count();
                this.checkSafetyResultIfNeed(safetyMaxResultSize, allRecordCount);
                selectedList = allRecordCount == 0 ? builder.buildEmptyListResultBean(pagingBean) : handler.paging();
            }
            PagingResultBean<ENTITY> rb = builder.buildPagingResultBean(pagingBean, allRecordCount, selectedList);
            if (pagingBean.canPagingReSelect() && this.isNecessaryToReadPageAgain(rb)) {
                pagingBean.fetchPage(rb.getAllPageCount());
                int reAllRecordCount = handler.count();
                List<ENTITY> reSelectedList = handler.paging();
                PagingResultBean<ENTITY> pagingResultBean = builder.buildPagingResultBean(pagingBean, reAllRecordCount, reSelectedList);
                return pagingResultBean;
            }
            PagingResultBean<ENTITY> pagingResultBean = rb;
            return pagingResultBean;
        }
        finally {
            pagingBean.xsetPaging(true);
        }
    }

    protected void throwPagingStatusInvalidException(PagingBean pagingBean) {
        boolean cbean = pagingBean instanceof ConditionBean;
        String name = cbean ? "condition-bean" : "parameter-bean";
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The status of paging was INVALID!" + this.ln();
        msg = msg + "(Paging parameters was not found)" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "Confirm your logic for paging of " + name + "." + this.ln();
        msg = msg + "Paging execution needs paging parameters 'pageSize' and 'pageNumber'." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    (x):" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        if (cbean) {
            msg = msg + "    MemberCB cb = new MemberCB();" + this.ln();
            msg = msg + "    cb.query().set...;" + this.ln();
            msg = msg + "    ... = memberBhv.selectPage(cb);" + this.ln();
        } else {
            msg = msg + "    SimpleMemberPmb pmb = new SimpleMemberPmb();" + this.ln();
            msg = msg + "    pmb.set...;" + this.ln();
            msg = msg + "    ... = memberBhv.outsideSql().manualPaging().selectPage(...);" + this.ln();
        }
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "    (o):" + this.ln();
        msg = msg + "    /- - - - - - - - - - - - - - - - - - - - - - - - - - " + this.ln();
        if (cbean) {
            msg = msg + "    MemberCB cb = new MemberCB();" + this.ln();
            msg = msg + "    cb.query().set...;" + this.ln();
            msg = msg + "    cb.paging(20, 2); // *Point!" + this.ln();
            msg = msg + "    ... = memberBhv.selectPage(cb);" + this.ln();
        } else {
            msg = msg + "    SimpleMemberPmb cb = new SimpleMemberPmb();" + this.ln();
            msg = msg + "    pmb.set...;" + this.ln();
            msg = msg + "    pmb.paging(20, 2); // *Point!" + this.ln();
            msg = msg + "    ... = memberBhv.outsideSql().manualPaging().selectPage(...);" + this.ln();
        }
        msg = msg + "    - - - - - - - - - -/" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Paging Bean]" + this.ln();
        msg = msg + pagingBean + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new PagingStatusInvalidException(msg);
    }

    protected ResultBeanBuilder<ENTITY> createResultBeanBuilder() {
        return new ResultBeanBuilder(this._tableDbName);
    }

    protected boolean isCurrentLastPage(List<ENTITY> selectedList, PagingBean pagingBean) {
        return selectedList.size() <= pagingBean.getFetchSize() - 1;
    }

    protected int deriveAllRecordCountFromLastPageValues(List<ENTITY> selectedList, PagingBean pagingBean) {
        int baseSize = (pagingBean.getFetchPageNumber() - 1) * pagingBean.getFetchSize();
        return baseSize + selectedList.size();
    }

    protected boolean isNecessaryToReadPageAgain(PagingResultBean<ENTITY> rb) {
        return rb.getAllRecordCount() > 0 && rb.getSelectedList().isEmpty();
    }

    protected void checkSafetyResultIfNeed(int safetyMaxResultSize, int allRecordCount) {
        if (safetyMaxResultSize > 0 && allRecordCount > safetyMaxResultSize) {
            String msg = "You've been in Danger Zone:";
            msg = msg + " safetyMaxResultSize=" + safetyMaxResultSize;
            msg = msg + " allRecordCount=" + allRecordCount;
            throw new DangerousResultSizeException(msg, safetyMaxResultSize, allRecordCount);
        }
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

