/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.identity;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.jdbc.ValueType;
import org.seasar.robot.dbflute.resource.SQLExceptionHandler;
import org.seasar.robot.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;

public abstract class TnIdentifierAbstractGenerator
implements TnIdentifierGenerator {
    protected TnPropertyType propertyType;
    protected TnResultSetHandler resultSetHandler;

    public TnIdentifierAbstractGenerator(TnPropertyType propertyType) {
        this.propertyType = propertyType;
        this.resultSetHandler = new InternalIdentifierResultSetHandler(propertyType.getValueType());
    }

    protected Object executeSql(DataSource ds, String sql, Object[] args) {
        TnBasicSelectHandler selectHandler = this.createSelectHandler(ds, sql);
        if (args != null) {
            selectHandler.setLoggingMessageSqlArgs(args);
        }
        return selectHandler.execute(args);
    }

    protected TnBasicSelectHandler createSelectHandler(DataSource ds, String sql) {
        return new TnBasicSelectHandler(ds, sql, this.resultSetHandler, this.createStatementFactory(ds, sql));
    }

    protected StatementFactory createStatementFactory(DataSource ds, String sql) {
        return new IdentifierGeneratorStatementFactory();
    }

    protected void reflectIdentifier(Object bean, Object value) {
        if (this.propertyType == null) {
            String msg = "The arguement[propertyType] should not be null: value=" + value;
            throw new IllegalArgumentException(msg);
        }
        DfPropertyDesc pd = this.propertyType.getPropertyDesc();
        pd.setValue(bean, value);
    }

    public String getPropertyName() {
        return this.propertyType.getPropertyName();
    }

    protected static class IdentifierGeneratorStatementFactory
    implements StatementFactory {
        protected IdentifierGeneratorStatementFactory() {
        }

        public PreparedStatement createPreparedStatement(Connection conn, String sql) {
            try {
                return conn.prepareStatement(sql);
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
                return null;
            }
        }

        public CallableStatement createCallableStatement(Connection conn, String sql) {
            try {
                return conn.prepareCall(sql);
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
                return null;
            }
        }

        protected void handleSQLException(SQLException e, Statement statement) {
            new SQLExceptionHandler().handleSQLException(e, statement);
        }
    }

    protected static class InternalIdentifierResultSetHandler
    implements TnResultSetHandler {
        private ValueType valueType;

        public InternalIdentifierResultSetHandler(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object handle(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return this.valueType.getValue(rs, 1);
            }
            return null;
        }
    }
}

