/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.bhv.core.SqlExecution;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnInsertAutoHandler;
import org.seasar.robot.dbflute.util.DfSystemUtil;

public class TnInsertAutoDynamicCommand
implements TnSqlCommand,
SqlExecution {
    private DataSource dataSource;
    private StatementFactory statementFactory;
    private TnBeanMetaData beanMetaData;
    private DBMeta targetDBMeta;
    private String[] propertyNames;

    public Object execute(Object[] args) {
        Object bean = args[0];
        TnBeanMetaData bmd = this.getBeanMetaData();
        TnPropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this.getPropertyNames());
        String sql = this.createInsertSql(bmd, propertyTypes);
        TnInsertAutoHandler handler = this.createInsertAutoHandler(bmd, propertyTypes);
        handler.setSql(sql);
        handler.setLoggingMessageSqlArgs(args);
        int rows = handler.execute(args);
        return rows;
    }

    protected String createInsertSql(TnBeanMetaData bmd, TnPropertyType[] propertyTypes) {
        int i;
        StringBuffer buf = new StringBuffer(100);
        buf.append("insert into ");
        buf.append(this.targetDBMeta.getTableSqlName());
        buf.append(" (");
        for (i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            String columnName = pt.getColumnName();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(columnName);
        }
        buf.append(")").append(this.getLineSeparator()).append(" values (");
        for (i = 0; i < propertyTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    protected TnInsertAutoHandler createInsertAutoHandler(TnBeanMetaData bmd, TnPropertyType[] propertyTypes) {
        return new TnInsertAutoHandler(this.dataSource, this.statementFactory, bmd, propertyTypes);
    }

    protected TnPropertyType[] createInsertPropertyTypes(TnBeanMetaData bmd, Object bean, String[] propertyNames) {
        if (0 == propertyNames.length) {
            String msg = "The property name was not found in the bean: " + bean;
            throw new IllegalStateException(msg);
        }
        ArrayList<TnPropertyType> types = new ArrayList<TnPropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName;
            TnIdentifierGenerator generator;
            TnPropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() ? !(generator = bmd.getIdentifierGenerator(pt.getPropertyName())).isSelfGenerate() : pt.getPropertyDesc().getValue(bean) == null && !(propertyName = pt.getPropertyName()).equalsIgnoreCase(timestampPropertyName) && !propertyName.equalsIgnoreCase(versionNoPropertyName)) continue;
            types.add(pt);
        }
        if (types.isEmpty()) {
            String msg = "The target property type was not found in the bean: " + bean;
            throw new IllegalStateException(msg);
        }
        TnPropertyType[] propertyTypes = types.toArray(new TnPropertyType[types.size()]);
        return propertyTypes;
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    protected TnBeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public void setBeanMetaData(TnBeanMetaData beanMetaData) {
        this.beanMetaData = beanMetaData;
    }

    public DBMeta getTargetDBMeta() {
        return this.targetDBMeta;
    }

    public void setTargetDBMeta(DBMeta targetDBMeta) {
        this.targetDBMeta = targetDBMeta;
    }

    protected String[] getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }
}

