/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;
import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvHandler;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.LhaEntryFilter;
import jp.sf.orangesignal.csv.ZipEntryFilter;

public abstract class Csv {
    protected Csv() {
    }

    public static <T> T load(CsvReader reader, CsvHandler<T> handler) throws IOException {
        return handler.load(reader);
    }

    public static <T> T load(Reader reader, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        return Csv.load(new CsvReader(reader, cfg), handler);
    }

    public static <T> T load(InputStream in, String encoding, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        return Csv.load(new InputStreamReader(in, encoding), cfg, handler);
    }

    public static <T> T load(InputStream in, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        return Csv.load(new InputStreamReader(in), cfg, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(File file, String encoding, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            T t = Csv.load(in, encoding, cfg, handler);
            return t;
        }
        finally {
            Csv.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T load(File file, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            T t = Csv.load(in, cfg, handler);
            return t;
        }
        finally {
            Csv.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(LhaInputStream in, String encoding, CsvConfig cfg, CsvListHandler<T> handler, LhaEntryFilter filter) throws IOException {
        LhaHeader entry;
        ArrayList<T> list = new ArrayList<T>();
        while ((entry = in.getNextEntry()) != null) {
            try {
                if (filter != null && !filter.accept(entry)) continue;
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader((InputStream)in, encoding), cfg), true));
            }
            finally {
                in.closeEntry();
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(LhaInputStream in, String encoding, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(in, encoding, cfg, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(LhaInputStream in, CsvConfig cfg, CsvListHandler<T> handler, LhaEntryFilter filter) throws IOException {
        LhaHeader entry;
        ArrayList<T> list = new ArrayList<T>();
        while ((entry = in.getNextEntry()) != null) {
            try {
                if (filter != null && !filter.accept(entry)) continue;
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader((InputStream)in), cfg), true));
            }
            finally {
                in.closeEntry();
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(LhaInputStream in, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(in, cfg, handler, null);
    }

    public static <T> List<T> load(LhaFile lhaFile, String encoding, CsvConfig cfg, CsvListHandler<T> handler, LhaEntryFilter filter) throws IOException {
        LhaHeader[] entries;
        ArrayList<T> list = new ArrayList<T>();
        for (LhaHeader entry : entries = lhaFile.getEntries()) {
            if (filter != null && !filter.accept(entry)) continue;
            list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader(lhaFile.getInputStream(entry), encoding), cfg), true));
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(LhaFile lhaFile, String encoding, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(lhaFile, encoding, cfg, handler, null);
    }

    public static <T> List<T> load(LhaFile lhaFile, CsvConfig cfg, CsvListHandler<T> handler, LhaEntryFilter filter) throws IOException {
        LhaHeader[] entries;
        ArrayList<T> list = new ArrayList<T>();
        for (LhaHeader entry : entries = lhaFile.getEntries()) {
            if (filter != null && !filter.accept(entry)) continue;
            list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader(lhaFile.getInputStream(entry)), cfg), true));
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(LhaFile lhaFile, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(lhaFile, cfg, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(ZipInputStream in, String encoding, CsvConfig cfg, CsvListHandler<T> handler, ZipEntryFilter filter) throws IOException {
        ZipEntry entry;
        ArrayList<T> list = new ArrayList<T>();
        while ((entry = in.getNextEntry()) != null) {
            try {
                if (filter != null && !filter.accept(entry)) continue;
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader((InputStream)in, encoding), cfg), true));
            }
            finally {
                in.closeEntry();
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(ZipInputStream in, String encoding, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(in, encoding, cfg, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(ZipInputStream in, CsvConfig cfg, CsvListHandler<T> handler, ZipEntryFilter filter) throws IOException {
        ZipEntry entry;
        ArrayList<T> list = new ArrayList<T>();
        while ((entry = in.getNextEntry()) != null) {
            try {
                if (filter != null && !filter.accept(entry)) continue;
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader(in), cfg), true));
            }
            finally {
                in.closeEntry();
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(ZipInputStream in, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(in, cfg, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(ZipFile zipFile, String encoding, CsvConfig cfg, CsvListHandler<T> handler, ZipEntryFilter filter) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (filter != null && !filter.accept(entry)) continue;
            InputStream in = zipFile.getInputStream(entry);
            try {
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader(in, encoding), cfg), true));
            }
            finally {
                Csv.closeQuietly(in);
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(ZipFile zipFile, String encoding, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(zipFile, encoding, cfg, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> load(ZipFile zipFile, CsvConfig cfg, CsvListHandler<T> handler, ZipEntryFilter filter) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (filter != null && !filter.accept(entry)) continue;
            InputStream in = zipFile.getInputStream(entry);
            try {
                list.addAll(handler.load(new CsvReader((Reader)new InputStreamReader(in), cfg), true));
            }
            finally {
                Csv.closeQuietly(in);
            }
        }
        return handler.processScalar(list);
    }

    public static <T> List<T> load(ZipFile zipFile, CsvConfig cfg, CsvListHandler<T> handler) throws IOException {
        return Csv.load(zipFile, cfg, handler, null);
    }

    public static <T> void save(T obj, CsvWriter writer, CsvHandler<T> handler) throws IOException {
        handler.save(obj, writer);
        writer.flush();
    }

    public static <T> void save(T obj, Writer writer, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        Csv.save(obj, new CsvWriter(writer, cfg), handler);
    }

    public static <T> void save(T obj, OutputStream out, String encoding, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        Csv.save(obj, new OutputStreamWriter(out, encoding), cfg, handler);
    }

    public static <T> void save(T obj, OutputStream out, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        Csv.save(obj, new OutputStreamWriter(out), cfg, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(T obj, File file, String encoding, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            Csv.save(obj, out, encoding, cfg, handler);
        }
        finally {
            Csv.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(T obj, File file, CsvConfig cfg, CsvHandler<T> handler) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            Csv.save(obj, out, cfg, handler);
        }
        finally {
            Csv.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(List<T> obj, LhaOutputStream out, String encoding, CsvConfig cfg, CsvListHandler<T> handler, String entryName) throws IOException {
        out.putNextEntry(new LhaHeader(entryName));
        try {
            Csv.save(obj, (OutputStream)out, encoding, cfg, handler);
        }
        finally {
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(List<T> obj, LhaOutputStream out, CsvConfig cfg, CsvListHandler<T> handler, String entryName) throws IOException {
        out.putNextEntry(new LhaHeader(entryName));
        try {
            Csv.save(obj, (OutputStream)out, cfg, handler);
        }
        finally {
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(List<T> obj, ZipOutputStream out, String encoding, CsvConfig cfg, CsvListHandler<T> handler, String entryName) throws IOException {
        out.putNextEntry(new ZipEntry(entryName));
        try {
            Csv.save(obj, (OutputStream)out, encoding, cfg, handler);
        }
        finally {
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void save(List<T> obj, ZipOutputStream out, CsvConfig cfg, CsvListHandler<T> handler, String entryName) throws IOException {
        out.putNextEntry(new ZipEntry(entryName));
        try {
            Csv.save(obj, out, cfg, handler);
        }
        finally {
            out.closeEntry();
        }
    }

    protected static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

