/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class CMSProcessableBodyPartInbound
implements CMSProcessable {
    private final BodyPart bodyPart;
    private final String defaultContentTransferEncoding;

    public CMSProcessableBodyPartInbound(BodyPart bodyPart) {
        this(bodyPart, "7bit");
    }

    public CMSProcessableBodyPartInbound(BodyPart bodyPart, String string) {
        this.bodyPart = bodyPart;
        this.defaultContentTransferEncoding = string;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            SMIMEUtil.outputBodyPart(outputStream, this.bodyPart, this.defaultContentTransferEncoding);
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    @Override
    public Object getContent() {
        return this.bodyPart;
    }
}

