/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.params.SpellingParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.AbstractLuceneSpellChecker;
import org.apache.solr.spelling.IndexBasedSpellChecker;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellCheckCollation;
import org.apache.solr.spelling.SpellCheckCollator;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingQueryConverter;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckComponent
extends SearchComponent
implements SolrCoreAware,
SpellingParams {
    private static final Logger LOG = LoggerFactory.getLogger(SpellCheckComponent.class);
    public static final boolean DEFAULT_ONLY_MORE_POPULAR = false;
    public static final String COMPONENT_NAME = "spellcheck";
    protected NamedList initParams;
    protected Map<String, SolrSpellChecker> spellCheckers = new ConcurrentHashMap<String, SolrSpellChecker>();
    protected QueryConverter queryConverter;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        if (params.getBool("spellcheck.build", false)) {
            spellChecker.build(rb.req.getCore(), rb.req.getSearcher());
            rb.rsp.add("command", "build");
        } else if (params.getBool("spellcheck.reload", false)) {
            spellChecker.reload(rb.req.getCore(), rb.req.getSearcher());
            rb.rsp.add("command", "reload");
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || this.spellCheckers.isEmpty()) {
            return;
        }
        boolean shardRequest = "true".equals(params.get("isShard"));
        String q = params.get("spellcheck.q");
        SolrSpellChecker spellChecker = this.getSpellChecker(params);
        Collection<Token> tokens = null;
        if (q != null) {
            tokens = this.getTokens(q, spellChecker.getQueryAnalyzer());
        } else {
            q = rb.getQueryString();
            if (q == null) {
                q = params.get("q");
            }
            tokens = this.queryConverter.convert(q);
        }
        if (tokens != null && !tokens.isEmpty()) {
            if (spellChecker != null) {
                SolrParams customParams;
                int count = params.getInt("spellcheck.count", 1);
                boolean onlyMorePopular = params.getBool("spellcheck.onlyMorePopular", false);
                boolean extendedResults = params.getBool("spellcheck.extendedResults", false);
                SimpleOrderedMap response = new SimpleOrderedMap();
                SolrIndexReader reader = rb.req.getSearcher().getReader();
                boolean collate = params.getBool("spellcheck.collate", false);
                float accuracy = params.getFloat("spellcheck.accuracy", Float.MIN_VALUE);
                SpellingOptions options = new SpellingOptions(tokens, (IndexReader)reader, count, onlyMorePopular, extendedResults, accuracy, customParams = this.getCustomParams(this.getDictionaryName(params), params, shardRequest));
                SpellingResult spellingResult = spellChecker.getSuggestions(options);
                if (spellingResult != null) {
                    NamedList suggestions = this.toNamedList(shardRequest, spellingResult, q, extendedResults, collate);
                    if (collate) {
                        this.addCollationsToResponse(params, spellingResult, rb, q, suggestions);
                    }
                    response.add("suggestions", (Object)suggestions);
                    rb.rsp.add(COMPONENT_NAME, response);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Specified dictionary does not exist.");
            }
        }
    }

    protected void addCollationsToResponse(SolrParams params, SpellingResult spellingResult, ResponseBuilder rb, String q, NamedList response) {
        int maxCollations = params.getInt("spellcheck.maxCollations", 1);
        int maxCollationTries = params.getInt("spellcheck.maxCollationTries", 0);
        int maxCollationEvaluations = params.getInt("spellcheck.maxCollationEvaluations", 10000);
        boolean collationExtendedResults = params.getBool("spellcheck.collateExtendedResults", false);
        boolean shard = params.getBool("isShard", false);
        SpellCheckCollator collator = new SpellCheckCollator();
        List<SpellCheckCollation> collations = collator.collate(spellingResult, q, rb, maxCollations, maxCollationTries, maxCollationEvaluations);
        Collections.sort(collations);
        for (SpellCheckCollation collation : collations) {
            if (collationExtendedResults) {
                NamedList extendedResult = new NamedList();
                extendedResult.add("collationQuery", (Object)collation.getCollationQuery());
                extendedResult.add("hits", (Object)collation.getHits());
                extendedResult.add("misspellingsAndCorrections", collation.getMisspellingsAndCorrections());
                if (maxCollationTries > 0 && shard) {
                    extendedResult.add("collationInternalRank", (Object)collation.getInternalRank());
                }
                response.add("collation", (Object)extendedResult);
                continue;
            }
            response.add("collation", (Object)collation.getCollationQuery());
            if (maxCollationTries <= 0 || !shard) continue;
            response.add("collationInternalRank", (Object)collation.getInternalRank());
        }
    }

    protected SolrParams getCustomParams(String dictionary, SolrParams params, boolean shardRequest) {
        ModifiableSolrParams result = new ModifiableSolrParams();
        Iterator iter = params.getParameterNamesIterator();
        String prefix = "spellcheck.." + dictionary + ".";
        while (iter.hasNext()) {
            String nxt = (String)iter.next();
            if (!nxt.startsWith(prefix)) continue;
            result.add(nxt.substring(prefix.length()), params.getParams(nxt));
        }
        if (shardRequest) {
            result.add("isShard", new String[]{"true"});
        }
        return result;
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            int count = sreq.params.getInt("spellcheck.count", 1);
            if (count < 5) {
                count = 5;
            }
            sreq.params.set("spellcheck.count", count);
            sreq.params.set(COMPONENT_NAME, new String[]{"true"});
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        Integer o;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        boolean extendedResults = params.getBool("spellcheck.extendedResults", false);
        boolean collate = params.getBool("spellcheck.collate", false);
        boolean collationExtendedResults = params.getBool("spellcheck.collateExtendedResults", false);
        int maxCollationTries = params.getInt("spellcheck.maxCollationTries", 0);
        int maxCollations = params.getInt("spellcheck.maxCollations", 1);
        String origQuery = params.get("spellcheck.q");
        if (origQuery == null && (origQuery = rb.getQueryString()) == null) {
            origQuery = params.get("q");
        }
        int count = rb.req.getParams().getInt("spellcheck.count", 1);
        float min = 0.5f;
        LevensteinDistance sd = null;
        int numSug = Math.max(count, 5);
        SolrSpellChecker checker = this.getSpellChecker(rb.req.getParams());
        if (checker instanceof AbstractLuceneSpellChecker) {
            AbstractLuceneSpellChecker spellChecker = (AbstractLuceneSpellChecker)checker;
            min = spellChecker.getAccuracy();
            sd = spellChecker.getStringDistance();
        }
        if (sd == null) {
            sd = new LevensteinDistance();
        }
        Collection<Token> tokens = null;
        try {
            tokens = this.getTokens(origQuery, checker.getQueryAnalyzer());
        }
        catch (IOException e) {
            LOG.error("Could not get tokens (this should never happen)", (Throwable)e);
        }
        HashMap<String, SpellCheckResponse.Suggestion> origVsSuggestion = new HashMap<String, SpellCheckResponse.Suggestion>();
        HashMap<String, Integer> origVsFreq = new HashMap<String, Integer>();
        HashMap<String, Integer> origVsShards = new HashMap<String, Integer>();
        LinkedHashMap origVsSuggested = new LinkedHashMap();
        HashMap<String, SuggestWord> suggestedVsWord = new HashMap<String, SuggestWord>();
        HashMap<String, SpellCheckCollation> collations = new HashMap<String, SpellCheckCollation>();
        int totalNumberShardResponses = 0;
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList nl = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                LOG.info(srsp.getShard() + " " + nl);
                if (nl == null) continue;
                ++totalNumberShardResponses;
                SpellCheckResponse spellCheckResp = new SpellCheckResponse(nl);
                for (SpellCheckResponse.Suggestion suggestion : spellCheckResp.getSuggestions()) {
                    origVsSuggestion.put(suggestion.getToken(), suggestion);
                    HashSet<String> suggested = (HashSet<String>)origVsSuggested.get(suggestion.getToken());
                    if (suggested == null) {
                        suggested = new HashSet<String>();
                        origVsSuggested.put(suggestion.getToken(), suggested);
                    }
                    int origFreq = 0;
                    o = (Integer)origVsFreq.get(suggestion.getToken());
                    if (o != null) {
                        origFreq += o.intValue();
                    }
                    origVsFreq.put(suggestion.getToken(), origFreq += suggestion.getOriginalFrequency());
                    Integer origShards = (Integer)origVsShards.get(suggestion.getToken());
                    if (origShards == null) {
                        origVsShards.put(suggestion.getToken(), 1);
                    } else {
                        origShards = origShards + 1;
                        origVsShards.put(suggestion.getToken(), origShards);
                    }
                    for (int i = 0; i < suggestion.getNumFound(); ++i) {
                        Integer freq;
                        String alternative = (String)suggestion.getAlternatives().get(i);
                        suggested.add(alternative);
                        SuggestWord sug = (SuggestWord)suggestedVsWord.get(alternative);
                        if (sug == null) {
                            sug = new SuggestWord();
                            suggestedVsWord.put(alternative, sug);
                        }
                        sug.string = alternative;
                        if (suggestion.getAlternativeFrequencies() == null || suggestion.getAlternativeFrequencies().size() <= 0 || (freq = (Integer)suggestion.getAlternativeFrequencies().get(i)) == null) continue;
                        sug.freq += freq.intValue();
                    }
                }
                NamedList suggestions = (NamedList)nl.get("suggestions");
                if (suggestions == null) continue;
                List collationList = suggestions.getAll("collation");
                List collationRankList = suggestions.getAll("collationInternalRank");
                int i = 0;
                if (collationList == null) continue;
                for (Object o2 : collationList) {
                    if (o2 instanceof String) {
                        SpellCheckCollation priorColl;
                        SpellCheckCollation coll = new SpellCheckCollation();
                        coll.setCollationQuery((String)o2);
                        if (collationRankList != null && collationRankList.size() > 0) {
                            coll.setInternalRank((Integer)collationRankList.get(i));
                            ++i;
                        }
                        if ((priorColl = (SpellCheckCollation)collations.get(coll.getCollationQuery())) != null) {
                            coll.setInternalRank(Math.max(coll.getInternalRank(), priorColl.getInternalRank()));
                        }
                        collations.put(coll.getCollationQuery(), coll);
                        continue;
                    }
                    NamedList expandedCollation = (NamedList)o2;
                    SpellCheckCollation coll = new SpellCheckCollation();
                    coll.setCollationQuery((String)expandedCollation.get("collationQuery"));
                    coll.setHits((Integer)expandedCollation.get("hits"));
                    if (maxCollationTries > 0) {
                        coll.setInternalRank((Integer)expandedCollation.get("collationInternalRank"));
                    }
                    coll.setMisspellingsAndCorrections((NamedList<String>)((NamedList)expandedCollation.get("misspellingsAndCorrections")));
                    SpellCheckCollation priorColl = (SpellCheckCollation)collations.get(coll.getCollationQuery());
                    if (priorColl != null) {
                        coll.setHits(coll.getHits() + priorColl.getHits());
                        coll.setInternalRank(Math.max(coll.getInternalRank(), priorColl.getInternalRank()));
                    }
                    collations.put(coll.getCollationQuery(), coll);
                }
            }
        }
        SpellingResult result = new SpellingResult(tokens);
        for (Map.Entry entry : origVsSuggested.entrySet()) {
            int k;
            SpellCheckResponse.Suggestion suggestion;
            String original = (String)entry.getKey();
            Integer numShards = (Integer)origVsShards.get(original);
            if (numShards < totalNumberShardResponses) continue;
            HashSet suggested = (HashSet)entry.getValue();
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
            for (String suggestion2 : suggested) {
                SuggestWord sug = (SuggestWord)suggestedVsWord.get(suggestion2);
                sug.score = sd.getDistance(original, sug.string);
                if (sug.score < min) continue;
                sugQueue.insertWithOverflow((Object)sug);
                if (sugQueue.size() != numSug) continue;
                min = ((SuggestWord)sugQueue.top()).score;
            }
            suggestion = (SpellCheckResponse.Suggestion)origVsSuggestion.get(original);
            Token token = new Token(original, suggestion.getStartOffset(), suggestion.getEndOffset());
            SuggestWord[] suggestions = new SuggestWord[Math.min(count, sugQueue.size())];
            for (k = 0; k < sugQueue.size() - count; ++k) {
                sugQueue.pop();
            }
            for (k = Math.min(count, sugQueue.size()) - 1; k >= 0; --k) {
                suggestions[k] = (SuggestWord)sugQueue.pop();
            }
            if (extendedResults) {
                o = (Integer)origVsFreq.get(original);
                if (o != null) {
                    result.addFrequency(token, o);
                }
                for (SuggestWord word : suggestions) {
                    result.add(token, word.string, word.freq);
                }
                continue;
            }
            ArrayList<String> words = new ArrayList<String>(sugQueue.size());
            for (SuggestWord word : suggestions) {
                words.add(word.string);
            }
            result.add(token, words);
        }
        SimpleOrderedMap response = new SimpleOrderedMap();
        NamedList suggestions = this.toNamedList(false, result, origQuery, extendedResults, collate);
        if (collate) {
            Object[] sortedCollations = collations.values().toArray(new SpellCheckCollation[collations.size()]);
            Arrays.sort(sortedCollations);
            for (int i = 0; i < maxCollations && i < sortedCollations.length; ++i) {
                Object collation = sortedCollations[i];
                if (collationExtendedResults) {
                    NamedList extendedResult = new NamedList();
                    extendedResult.add("collationQuery", (Object)((SpellCheckCollation)collation).getCollationQuery());
                    extendedResult.add("hits", (Object)((SpellCheckCollation)collation).getHits());
                    extendedResult.add("misspellingsAndCorrections", ((SpellCheckCollation)collation).getMisspellingsAndCorrections());
                    suggestions.add("collation", (Object)extendedResult);
                    continue;
                }
                suggestions.add("collation", (Object)((SpellCheckCollation)collation).getCollationQuery());
            }
        }
        response.add("suggestions", (Object)suggestions);
        rb.rsp.add(COMPONENT_NAME, response);
    }

    private Collection<Token> getTokens(String q, Analyzer analyzer) throws IOException {
        ArrayList<Token> result = new ArrayList<Token>();
        TokenStream ts = analyzer.reusableTokenStream("", (Reader)new StringReader(q));
        ts.reset();
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        TypeAttribute typeAtt = (TypeAttribute)ts.addAttribute(TypeAttribute.class);
        FlagsAttribute flagsAtt = (FlagsAttribute)ts.addAttribute(FlagsAttribute.class);
        PayloadAttribute payloadAtt = (PayloadAttribute)ts.addAttribute(PayloadAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
        while (ts.incrementToken()) {
            Token token = new Token();
            token.copyBuffer(termAtt.buffer(), 0, termAtt.length());
            token.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
            token.setType(typeAtt.type());
            token.setFlags(flagsAtt.getFlags());
            token.setPayload(payloadAtt.getPayload());
            token.setPositionIncrement(posIncAtt.getPositionIncrement());
            result.add(token);
        }
        ts.end();
        ts.close();
        return result;
    }

    protected SolrSpellChecker getSpellChecker(SolrParams params) {
        return this.spellCheckers.get(this.getDictionaryName(params));
    }

    private String getDictionaryName(SolrParams params) {
        String dictName = params.get("spellcheck.dictionary");
        if (dictName == null) {
            dictName = "default";
        }
        return dictName;
    }

    public SolrSpellChecker getSpellChecker(String name) {
        return this.spellCheckers.get(name);
    }

    protected NamedList toNamedList(boolean shardRequest, SpellingResult spellingResult, String origQuery, boolean extendedResults, boolean collate) {
        NamedList result = new NamedList();
        Map<Token, LinkedHashMap<String, Integer>> suggestions = spellingResult.getSuggestions();
        boolean hasFreqInfo = spellingResult.hasTokenFrequencyInfo();
        boolean isCorrectlySpelled = false;
        int numSuggestions = 0;
        for (LinkedHashMap<String, Integer> linkedHashMap : suggestions.values()) {
            if (linkedHashMap.size() <= 0) continue;
            ++numSuggestions;
        }
        if (numSuggestions > 0) {
            isCorrectlySpelled = true;
        }
        for (Map.Entry entry : suggestions.entrySet()) {
            Token inputToken = (Token)entry.getKey();
            Map theSuggestions = (Map)entry.getValue();
            if (theSuggestions == null || theSuggestions.size() <= 0 && !shardRequest) continue;
            SimpleOrderedMap suggestionList = new SimpleOrderedMap();
            suggestionList.add("numFound", (Object)theSuggestions.size());
            suggestionList.add("startOffset", (Object)inputToken.startOffset());
            suggestionList.add("endOffset", (Object)inputToken.endOffset());
            if (extendedResults && hasFreqInfo) {
                suggestionList.add("origFreq", (Object)spellingResult.getTokenFrequency(inputToken));
                ArrayList<SimpleOrderedMap> sugs = new ArrayList<SimpleOrderedMap>();
                suggestionList.add("suggestion", sugs);
                for (Map.Entry suggEntry : theSuggestions.entrySet()) {
                    SimpleOrderedMap sugEntry = new SimpleOrderedMap();
                    sugEntry.add("word", suggEntry.getKey());
                    sugEntry.add("freq", suggEntry.getValue());
                    sugs.add(sugEntry);
                }
            } else {
                suggestionList.add("suggestion", theSuggestions.keySet());
            }
            if (hasFreqInfo) {
                isCorrectlySpelled = isCorrectlySpelled && spellingResult.getTokenFrequency(inputToken) > 0;
            }
            result.add(new String(inputToken.buffer(), 0, inputToken.length()), (Object)suggestionList);
        }
        if (hasFreqInfo) {
            result.add("correctlySpelled", (Object)isCorrectlySpelled);
        } else if (extendedResults && suggestions.size() == 0) {
            result.add("correctlySpelled", (Object)true);
        }
        return result;
    }

    @Override
    public void inform(SolrCore core) {
        if (this.initParams != null) {
            LOG.info("Initializing spell checkers");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                SolrResourceLoader loader;
                SolrSpellChecker checker;
                if (!this.initParams.getName(i).equals("spellchecker")) continue;
                NamedList spellchecker = (NamedList)this.initParams.getVal(i);
                String className = (String)spellchecker.get("classname");
                if (className == null) {
                    className = IndexBasedSpellChecker.class.getName();
                }
                if ((checker = (SolrSpellChecker)(loader = core.getResourceLoader()).newInstance(className, new String[0])) != null) {
                    String dictionary = checker.init(spellchecker, core);
                    if (dictionary != null) {
                        boolean isDefault = dictionary.equals("default");
                        if (isDefault && !hasDefault) {
                            hasDefault = true;
                        } else if (isDefault && hasDefault) {
                            throw new RuntimeException("More than one dictionary is missing name.");
                        }
                        this.spellCheckers.put(dictionary, checker);
                    } else if (!hasDefault) {
                        this.spellCheckers.put("default", checker);
                        hasDefault = true;
                    } else {
                        throw new RuntimeException("More than one dictionary is missing name.");
                    }
                    core.registerFirstSearcherListener(new SpellCheckerListener(core, checker, false, false));
                    boolean buildOnCommit = Boolean.parseBoolean((String)spellchecker.get("buildOnCommit"));
                    boolean buildOnOptimize = Boolean.parseBoolean((String)spellchecker.get("buildOnOptimize"));
                    if (!buildOnCommit && !buildOnOptimize) continue;
                    LOG.info("Registering newSearcher listener for spellchecker: " + checker.getDictionaryName());
                    core.registerNewSearcherListener(new SpellCheckerListener(core, checker, buildOnCommit, buildOnOptimize));
                    continue;
                }
                throw new RuntimeException("Can't load spell checker: " + className);
            }
            HashMap<String, SpellingQueryConverter> queryConverters = new HashMap<String, SpellingQueryConverter>();
            core.initPlugins(queryConverters, QueryConverter.class);
            if (queryConverters.size() == 0) {
                LOG.info("No queryConverter defined, using default converter");
                queryConverters.put("queryConverter", new SpellingQueryConverter());
            }
            if (queryConverters.size() == 1) {
                this.queryConverter = (QueryConverter)queryConverters.values().iterator().next();
                IndexSchema schema = core.getSchema();
                String fieldTypeName = (String)this.initParams.get("queryAnalyzerFieldType");
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                WhitespaceAnalyzer analyzer = fieldType == null ? new WhitespaceAnalyzer(core.getSolrConfig().luceneMatchVersion) : fieldType.getQueryAnalyzer();
                this.queryConverter.setAnalyzer((Analyzer)analyzer);
            }
        }
    }

    public Map<String, SolrSpellChecker> getSpellCheckers() {
        return Collections.unmodifiableMap(this.spellCheckers);
    }

    @Override
    public String getDescription() {
        return "A Spell Checker component";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1305693 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: SpellCheckComponent.java 1305693 2012-03-27 00:43:47Z janhoy $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_6/solr/core/src/java/org/apache/solr/handler/component/SpellCheckComponent.java $";
    }

    private static class SpellCheckerListener
    implements SolrEventListener {
        private final SolrCore core;
        private final SolrSpellChecker checker;
        private final boolean buildOnCommit;
        private final boolean buildOnOptimize;

        public SpellCheckerListener(SolrCore core, SolrSpellChecker checker, boolean buildOnCommit, boolean buildOnOptimize) {
            this.core = core;
            this.checker = checker;
            this.buildOnCommit = buildOnCommit;
            this.buildOnOptimize = buildOnOptimize;
        }

        public void init(NamedList args) {
        }

        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            if (currentSearcher == null) {
                try {
                    LOG.info("Loading spell index for spellchecker: " + this.checker.getDictionaryName());
                    this.checker.reload(this.core, newSearcher);
                }
                catch (IOException e) {
                    log.error("Exception in reloading spell check index for spellchecker: " + this.checker.getDictionaryName(), (Throwable)e);
                }
            } else if (this.buildOnCommit) {
                this.buildSpellIndex(newSearcher);
            } else if (this.buildOnOptimize) {
                if (newSearcher.getIndexReader().getSequentialSubReaders().length == 1) {
                    this.buildSpellIndex(newSearcher);
                } else {
                    LOG.info("Index is not optimized therefore skipping building spell check index for: " + this.checker.getDictionaryName());
                }
            }
        }

        private void buildSpellIndex(SolrIndexSearcher newSearcher) {
            try {
                LOG.info("Building spell index for spell checker: " + this.checker.getDictionaryName());
                this.checker.build(this.core, newSearcher);
            }
            catch (Exception e) {
                log.error("Exception in building spell check index for spellchecker: " + this.checker.getDictionaryName(), (Throwable)e);
            }
        }

        public void postCommit() {
        }
    }
}

