/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrieDateField
extends DateField {
    final TrieField wrappedField = new TrieField(){
        {
            this.type = TrieField.TrieTypes.DATE;
        }
    };

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.wrappedField.init(schema, args);
        this.analyzer = this.wrappedField.analyzer;
        this.queryAnalyzer = this.wrappedField.queryAnalyzer;
    }

    @Override
    public Date toObject(Fieldable f) {
        return (Date)this.wrappedField.toObject(f);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.wrappedField.getSortField(field, top);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return this.wrappedField.getValueSource(field, parser);
    }

    public int getPrecisionStep() {
        return this.wrappedField.getPrecisionStep();
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        this.wrappedField.write(xmlWriter, name, f);
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        this.wrappedField.write(writer, name, f);
    }

    @Override
    public boolean isTokenized() {
        return this.wrappedField.isTokenized();
    }

    @Override
    public boolean multiValuedFieldCache() {
        return this.wrappedField.multiValuedFieldCache();
    }

    @Override
    public String storedToReadable(Fieldable f) {
        return this.wrappedField.storedToReadable(f);
    }

    @Override
    public String readableToIndexed(String val) {
        return this.wrappedField.readableToIndexed(val);
    }

    @Override
    public String toInternal(String val) {
        return this.wrappedField.toInternal(val);
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.wrappedField.toExternal(f);
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return this.wrappedField.indexedToReadable(indexedForm);
    }

    @Override
    public String storedToIndexed(Fieldable f) {
        return this.wrappedField.storedToIndexed(f);
    }

    @Override
    public Fieldable createField(SchemaField field, String externalVal, float boost) {
        return this.wrappedField.createField(field, externalVal, boost);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return this.wrappedField.getRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField sf, Date min, Date max, boolean minInclusive, boolean maxInclusive) {
        return NumericRangeQuery.newLongRange((String)sf.getName(), (int)this.wrappedField.precisionStep, (Long)(min == null ? null : Long.valueOf(min.getTime())), (Long)(max == null ? null : Long.valueOf(max.getTime())), (boolean)minInclusive, (boolean)maxInclusive);
    }
}

