/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.net.URL;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;

public class SolrFieldCacheMBean
implements SolrInfoMBean {
    protected FieldCacheSanityChecker checker = new FieldCacheSanityChecker();

    public String getName() {
        return this.getClass().getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Provides introspection of the Lucene FieldCache, this is **NOT** a cache that is managed by Solr.";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    public String getSourceId() {
        return "$Id: SolrFieldCacheMBean.java 984594 2010-08-11 21:42:04Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_6/solr/core/src/java/org/apache/solr/search/SolrFieldCacheMBean.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        stats.add("entries_count", (Object)entries.length);
        for (int i = 0; i < entries.length; ++i) {
            FieldCache.CacheEntry e = entries[i];
            stats.add("entry#" + i, (Object)e.toString());
        }
        FieldCacheSanityChecker.Insanity[] insanity = this.checker.check(entries);
        stats.add("insanity_count", (Object)insanity.length);
        for (int i = 0; i < insanity.length; ++i) {
            stats.add("insanity#" + i, (Object)insanity[i].toString());
        }
        return stats;
    }
}

