/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.net.HttpURLConnection;
import javax.servlet.http.HttpServletRequest;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.image.ConnectionStream;
import org.mobylet.core.image.ImageClipRectangle;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class ImageUtils {
    public static final String CONTENTTYPE_JPEG = "image/jpeg";
    public static final String CONTENTTYPE_JPG_NOUSE = "image/jpg";
    public static final String CONTENTTYPE_GIF = "image/gif";
    public static final String CONTENTTYPE_PNG = "image/png";

    public static String getContentTypeStringByRequestURI() {
        String uri = RequestUtils.get().getRequestURI();
        return ImageUtils.getContentTypeString(uri);
    }

    public static String getContentTypeString(String uri) {
        ImageCodec codec = ImageUtils.getImageCodec(uri);
        if (codec != null) {
            return ImageUtils.getContentTypeString(codec);
        }
        return null;
    }

    public static String getContentTypeString(ImageCodec codec) {
        if (codec == null) {
            return null;
        }
        switch (codec) {
            case JPG: {
                return CONTENTTYPE_JPEG;
            }
            case GIF: {
                return CONTENTTYPE_GIF;
            }
            case PNG: {
                return CONTENTTYPE_PNG;
            }
        }
        return "";
    }

    public static ImageCodec getImageCodec() {
        String uri = RequestUtils.get().getRequestURI();
        return ImageUtils.getImageCodec(uri);
    }

    public static ImageCodec getImageCodec(String uri) {
        if (StringUtils.isNotEmpty(uri)) {
            String suffix4;
            String suffix;
            String codecStr = RequestUtils.get().getParameter("codec");
            if (StringUtils.isNotEmpty(codecStr)) {
                return ImageCodec.valueOf(codecStr);
            }
            int index = -1;
            index = uri.indexOf(63);
            if (index > 0 || (index = uri.indexOf(59)) > 0) {
                uri = uri.substring(0, index);
            }
            if ((suffix = uri.substring(uri.lastIndexOf(46) + 1, uri.length())).length() >= 3) {
                String suffix3 = suffix.substring(0, 3);
                if (suffix3.equalsIgnoreCase("jpg")) {
                    return ImageCodec.JPG;
                }
                if (suffix3.equalsIgnoreCase("gif")) {
                    return ImageCodec.GIF;
                }
                if (suffix3.equalsIgnoreCase("png")) {
                    return ImageCodec.PNG;
                }
            }
            if (suffix.length() >= 4 && (suffix4 = suffix.substring(0, 4)).equalsIgnoreCase("jpeg")) {
                return ImageCodec.JPG;
            }
        }
        return null;
    }

    public static ImageCodec getImageCodec(ConnectionStream connectionStream) {
        HttpURLConnection connection;
        String contentType;
        if (connectionStream != null && connectionStream.getConnection() != null && StringUtils.isNotEmpty(contentType = (connection = connectionStream.getConnection()).getHeaderField("Content-Type"))) {
            if ((contentType = contentType.toLowerCase()).contains(CONTENTTYPE_JPEG) || contentType.contains(CONTENTTYPE_JPG_NOUSE)) {
                return ImageCodec.JPG;
            }
            if (contentType.contains(CONTENTTYPE_GIF)) {
                return ImageCodec.GIF;
            }
            if (contentType.contains(CONTENTTYPE_PNG)) {
                return ImageCodec.PNG;
            }
        }
        return null;
    }

    public static ImageCodec getImageCodec(byte[] imgBytes) {
        if (imgBytes != null && imgBytes.length >= 2) {
            int b1 = imgBytes[0] & 0xFF;
            int b2 = imgBytes[1] & 0xFF;
            if (b1 == 255 && b2 == 216) {
                return ImageCodec.JPG;
            }
            if (b1 == 71 && b2 == 73) {
                return ImageCodec.GIF;
            }
            if (b1 == 137 && b2 == 80) {
                return ImageCodec.PNG;
            }
        }
        return null;
    }

    public static ScaleType getScaleType() {
        return ImageUtils.getScaleType(RequestUtils.get().getParameter("scaleType"));
    }

    public static ScaleType getScaleType(String scaleTypeStr) {
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        ScaleType scaleType = null;
        if (StringUtils.isNotEmpty(scaleTypeStr)) {
            scaleType = ScaleType.valueOf(scaleTypeStr);
            if (scaleType == null) {
                scaleType = config.getDefaultScaleType();
            }
        } else {
            scaleType = config.getDefaultScaleType();
        }
        return scaleType;
    }

    public static ImageClipRectangle getClipRectangle(int width, int height, int newWidth, ScaleType scaleType) {
        if (scaleType == null) {
            return new ImageClipRectangle(0, 0, width, height);
        }
        switch (scaleType) {
            case CLIPSQUARE: {
                if (width > height) {
                    int w = (int)((double)width * (double)newWidth / (double)height);
                    return new ImageClipRectangle((w - newWidth) / 2, 0, w, newWidth);
                }
                int h = (int)((double)height * (double)newWidth / (double)width);
                return new ImageClipRectangle(0, (h - newWidth) / 2, newWidth, h);
            }
            case INSQUARE: {
                if (width > height) {
                    return ImageUtils.getClipRectangle(width, height, newWidth, ScaleType.FITWIDTH);
                }
                return new ImageClipRectangle(0, 0, (int)((double)width * (double)newWidth / (double)height), newWidth);
            }
            case FITWIDTH: {
                return new ImageClipRectangle(0, 0, newWidth, (int)((double)height * (double)newWidth / (double)width));
            }
        }
        return null;
    }

    public static Integer getScaledWidth() {
        Mobylet m = MobyletFactory.getInstance();
        DeviceDisplay dp = m.getDisplay();
        HttpServletRequest request = RequestUtils.get();
        String w = request.getParameter("w");
        Integer iw = null;
        if (dp != null && StringUtils.isNotEmpty(w)) {
            try {
                Double dw = Double.valueOf(w);
                if (dw > 1.0) {
                    dw = 1.0;
                }
                iw = (int)(dw * (double)dp.getWidth().intValue());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return iw;
    }

    public static boolean isAutoScale() {
        HttpServletRequest request;
        ImageCodec codec = ImageUtils.getImageCodec();
        return codec != null && "on".equalsIgnoreCase((request = RequestUtils.get()).getParameter("autoScale")) && StringUtils.isNotEmpty(request.getParameter("w"));
    }
}

