/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.extractor.ExtractorFactory;
import org.seasar.robot.helper.MimeTypeHelper;
import org.seasar.robot.util.IgnoreCloseInputStream;
import org.seasar.robot.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LhaExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(LhaExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        StringBuilder buf;
        block22: {
            LhaFile lhaFile;
            File tempFile;
            block21: {
                if (in == null) {
                    throw new RobotSystemException("The inputstream is null.");
                }
                MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
                if (mimeTypeHelper == null) {
                    throw new RobotSystemException("MimeTypeHelper is unavailable.");
                }
                ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
                if (extractorFactory == null) {
                    throw new RobotSystemException("ExtractorFactory is unavailable.");
                }
                buf = new StringBuilder(1000);
                tempFile = null;
                lhaFile = null;
                tempFile = File.createTempFile("s2robot-", ".lzh");
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                    StreamUtil.drain(in, bos);
                    bos.flush();
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)bos);
                lhaFile = new LhaFile(tempFile);
                Enumeration entries = lhaFile.entries();
                while (entries.hasMoreElements()) {
                    Object var17_20;
                    Extractor extractor;
                    LhaHeader head = (LhaHeader)entries.nextElement();
                    String filename = head.getPath();
                    String mimeType = mimeTypeHelper.getContentType(null, filename);
                    if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                    InputStream is = null;
                    try {
                        is = lhaFile.getInputStream(head);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("resourceName", filename);
                        buf.append(extractor.getText(new IgnoreCloseInputStream(is), map).getContent());
                        buf.append('\n');
                        var17_20 = null;
                    }
                    catch (Throwable throwable) {
                        var17_20 = null;
                        IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    {
                        continue;
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Exception in an internal extractor.", (Throwable)e);
                            }
                            var17_20 = null;
                            IOUtils.closeQuietly((InputStream)is);
                        }
                    }
                }
                Object var19_22 = null;
                if (lhaFile == null) break block21;
                try {
                    lhaFile.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            break block22;
            {
                catch (Exception e) {
                    throw new ExtractException("Could not extract a content.", e);
                }
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                if (lhaFile != null) {
                    try {
                        lhaFile.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                throw throwable;
            }
        }
        return new ExtractData(buf.toString());
    }
}

