/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSitemapsException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.SitemapFile;
import org.seasar.robot.entity.SitemapSet;
import org.seasar.robot.entity.SitemapUrl;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SitemapsHelper {
    public int preloadSize = 512;

    public SitemapSet parse(InputStream in) {
        return this.parse(in, true);
    }

    protected SitemapSet parse(InputStream in, boolean recursive) {
        BufferedInputStream bis = new BufferedInputStream(in);
        bis.mark(this.preloadSize);
        byte[] bytes = new byte[this.preloadSize];
        try {
            if (bis.read(bytes) == -1) {
                throw new RobotSitemapsException("No sitemaps data.");
            }
            String preloadDate = new String(bytes, "UTF-8");
            if (preloadDate.indexOf("<urlset") >= 0) {
                bis.reset();
                return this.parseXmlSitemaps(bis);
            }
            if (preloadDate.indexOf("<sitemapindex") >= 0) {
                bis.reset();
                return this.parseXmlSitemapsIndex(bis);
            }
            if (preloadDate.startsWith("http://") || preloadDate.startsWith("https://")) {
                bis.reset();
                return this.parseTextSitemaps(bis);
            }
            bis.reset();
            return this.parse(new GZIPInputStream(bis), false);
        }
        catch (RobotSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RobotSitemapsException("Could not parse Sitemaps.", e);
        }
    }

    protected SitemapSet parseTextSitemaps(InputStream in) {
        SitemapSet sitemapSet = new SitemapSet();
        sitemapSet.setType("UrlSet");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = br.readLine()) != null) {
                String url = line.trim();
                if (!StringUtil.isNotBlank((String)url) || !url.startsWith("http://") && !url.startsWith("https://")) continue;
                SitemapUrl sitemapUrl = new SitemapUrl();
                sitemapUrl.setLoc(url);
                sitemapSet.addSitemap(sitemapUrl);
            }
            return sitemapSet;
        }
        catch (Exception e) {
            throw new RobotSitemapsException("Could not parse Text Sitemaps.", e);
        }
    }

    protected SitemapSet parseXmlSitemaps(InputStream in) {
        XmlSitemapsHandler handler = new XmlSitemapsHandler();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RobotSitemapsException("Could not parse XML Sitemaps.", e);
        }
        return handler.getSitemapSet();
    }

    protected SitemapSet parseXmlSitemapsIndex(InputStream in) {
        XmlSitemapsIndexHandler handler = new XmlSitemapsIndexHandler();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RobotSitemapsException("Could not parse XML Sitemaps Index.", e);
        }
        return handler.getSitemapSet();
    }

    protected static class XmlSitemapsIndexHandler
    extends DefaultHandler {
        private SitemapSet sitemapSet;
        private SitemapFile sitemapFile;
        private StringBuilder buf;

        protected XmlSitemapsIndexHandler() {
        }

        public void startDocument() {
            this.sitemapSet = new SitemapSet();
            this.sitemapSet.setType("Index");
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("sitemap".equals(qName)) {
                this.sitemapFile = new SitemapFile();
            } else if ("loc".equals(qName)) {
                this.buf = new StringBuilder();
            } else if ("lastmod".equals(qName)) {
                this.buf = new StringBuilder();
            }
        }

        public void characters(char[] ch, int offset, int length) {
            if (this.buf != null) {
                this.buf.append(new String(ch, offset, length));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if ("sitemap".equals(qName)) {
                this.sitemapSet.addSitemap(this.sitemapFile);
                this.sitemapFile = null;
            } else if ("loc".equals(qName)) {
                if (this.buf != null) {
                    this.sitemapFile.setLoc(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if ("lastmod".equals(qName) && this.buf != null) {
                this.sitemapFile.setLastmod(this.buf.toString().trim());
                this.buf = null;
            }
        }

        public void endDocument() {
        }

        public SitemapSet getSitemapSet() {
            return this.sitemapSet;
        }
    }

    protected static class XmlSitemapsHandler
    extends DefaultHandler {
        private static final String PRIORITY_ELEMENT = "priority";
        private static final String CHANGEFREQ_ELEMENT = "changefreq";
        private static final String LASTMOD_ELEMENT = "lastmod";
        private static final String LOC_ELEMENT = "loc";
        private static final String URL_ELEMENT = "url";
        private SitemapSet sitemapSet;
        private SitemapUrl sitemapUrl;
        private StringBuilder buf;

        protected XmlSitemapsHandler() {
        }

        public void startDocument() {
            this.sitemapSet = new SitemapSet();
            this.sitemapSet.setType("UrlSet");
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (URL_ELEMENT.equals(qName)) {
                this.sitemapUrl = new SitemapUrl();
            } else if (LOC_ELEMENT.equals(qName)) {
                this.buf = new StringBuilder();
            } else if (LASTMOD_ELEMENT.equals(qName)) {
                this.buf = new StringBuilder();
            } else if (CHANGEFREQ_ELEMENT.equals(qName)) {
                this.buf = new StringBuilder();
            } else if (PRIORITY_ELEMENT.equals(qName)) {
                this.buf = new StringBuilder();
            }
        }

        public void characters(char[] ch, int offset, int length) {
            if (this.buf != null) {
                this.buf.append(new String(ch, offset, length));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (URL_ELEMENT.equals(qName)) {
                this.sitemapSet.addSitemap(this.sitemapUrl);
                this.sitemapUrl = null;
            } else if (LOC_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setLoc(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (LASTMOD_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setLastmod(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (CHANGEFREQ_ELEMENT.equals(qName)) {
                if (this.buf != null) {
                    this.sitemapUrl.setChangefreq(this.buf.toString().trim());
                    this.buf = null;
                }
            } else if (PRIORITY_ELEMENT.equals(qName) && this.buf != null) {
                this.sitemapUrl.setPriority(this.buf.toString().trim());
                this.buf = null;
            }
        }

        public void endDocument() {
        }

        public SitemapSet getSitemapSet() {
            return this.sitemapSet;
        }
    }
}

