/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.helper.MimeTypeException;
import org.seasar.robot.helper.MimeTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTypeHelperImpl
implements MimeTypeHelper {
    private static final String MIME_TYPES_RESOURCE_NAME = "/org/seasar/robot/mime/tika-mimetypes.xml";
    private MimeTypes mimeTypes;

    public MimeTypeHelperImpl() {
        try {
            this.mimeTypes = MimeTypesFactory.create((String)MIME_TYPES_RESOURCE_NAME);
        }
        catch (Exception e) {
            throw new RobotSystemException("Could not initialize MimeTypeHelper.", e);
        }
    }

    @Override
    public String getContentType(InputStream is, String filename) {
        if (StringUtil.isEmpty((String)filename)) {
            throw new MimeTypeException("The filename is empty.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceName", filename);
        return this.getContentType(is, params);
    }

    @Override
    public String getContentType(InputStream is, Map<String, String> params) {
        String filename = params.get("resourceName");
        if (StringUtil.isEmpty((String)filename) && is == null) {
            throw new MimeTypeException("The filename or input stream is empty.");
        }
        Metadata metadata = new Metadata();
        metadata.add("resourceName", filename);
        try {
            MediaType mediaType = this.mimeTypes.detect(is == null || is.markSupported() ? is : new BufferedInputStream(is), metadata);
            return mediaType.getType() + "/" + mediaType.getSubtype();
        }
        catch (IOException e) {
            throw new MimeTypeException("Could not detect a content type.", e);
        }
    }
}

