/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.subquery;

import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.subquery.AbstractSubQuery;
import org.seasar.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;
import org.seasar.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarCondition
extends AbstractSubQuery {
    protected final String _mainSubQueryIdentity;
    protected final String _operand;

    public ScalarCondition(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, String mainSubQueryIdentity, String operand) {
        super(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQuerySqlClause, subQueryIdentity, subQueryDBMeta, cipherManager);
        this._mainSubQueryIdentity = mainSubQueryIdentity;
        this._operand = operand;
    }

    public String buildScalarCondition(String function) {
        String columnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (columnDbName == null || columnDbName.trim().length() == 0) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnRealName columnRealName = this._localRealNameProvider.provide(columnDbName);
        String subQueryClause = this.getSubQueryClause(function);
        String beginMark = this.resolveSubQueryBeginMark(this._subQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._subQueryIdentity);
        String endIndent = "       ";
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        String specifiedExp = this.decrypt(columnInfo, columnRealName.toString());
        return specifiedExp + " " + this._operand + " (" + beginMark + subQueryClause + this.ln() + "       " + ") " + endMark;
    }

    protected String getSubQueryClause(String function) {
        String subQueryClause;
        if (!this._subQueryDBMeta.hasPrimaryKey() || this._subQueryDBMeta.hasCompoundPrimaryKey()) {
            String msg = "The scalar-condition is unsupported when no primary key or compound primary key:";
            msg = msg + " table=" + this._subQueryDBMeta.getTableDbName();
            throw new IllegalConditionBeanOperationException(msg);
        }
        String tableAliasName = this.getSubQueryLocalAliasName();
        String derivedColumnDbName = this._subQuerySqlClause.getSpecifiedColumnDbNameAsOne();
        if (derivedColumnDbName == null) {
            this.throwScalarConditionInvalidColumnSpecificationException(function);
        }
        ColumnSqlName derivedColumnSqlName = this._subQuerySqlClause.getSpecifiedColumnSqlNameAsOne();
        ColumnRealName derivedColumnRealName = new ColumnRealName(tableAliasName, derivedColumnSqlName);
        this.assertScalarConditionColumnType(function, derivedColumnDbName);
        if (this._subQuerySqlClause.hasUnionQuery()) {
            subQueryClause = this.getUnionSubQuerySql(function, tableAliasName, derivedColumnSqlName, derivedColumnRealName);
        } else {
            ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
            String specifiedExp = this.decrypt(columnInfo, derivedColumnRealName.toString());
            String selectClause = "select " + function + "(" + specifiedExp + ")";
            String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName);
            subQueryClause = selectClause + " " + fromWhereClause;
        }
        return this.resolveSubQueryLevelVariable(subQueryClause);
    }

    protected String getUnionSubQuerySql(String function, String tableAliasName, ColumnSqlName derivedColumnSqlName, ColumnRealName derivedColumnRealName) {
        String beginMark = this.resolveSubQueryBeginMark(this._mainSubQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._mainSubQueryIdentity);
        ColumnSqlName pkSqlName = this._subQueryDBMeta.getPrimaryUniqueInfo().getFirstColumn().getColumnSqlName();
        ColumnRealName pkRealName = new ColumnRealName(tableAliasName, pkSqlName);
        String selectClause = "select " + pkRealName + ", " + derivedColumnRealName;
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName);
        String mainSql = selectClause + " " + fromWhereClause;
        String mainAlias = this.buildSubQueryMainAliasName();
        ColumnRealName mainDerivedColumnRealName = new ColumnRealName(mainAlias, derivedColumnSqlName);
        ColumnInfo columnInfo = this._subQuerySqlClause.getSpecifiedColumnInfoAsOne();
        String specifiedExp = this.decrypt(columnInfo, mainDerivedColumnRealName.toString());
        return "select " + function + "(" + specifiedExp + ")" + this.ln() + "  from (" + beginMark + mainSql + this.ln() + "       ) " + mainAlias + endMark;
    }

    protected void throwScalarConditionInvalidColumnSpecificationException(String function) {
        this.createCBExThrower().throwScalarConditionInvalidColumnSpecificationException(function);
    }

    protected void assertScalarConditionColumnType(String function, String derivedColumnDbName) {
        Class<?> deriveColumnType = this._subQueryDBMeta.findColumnInfo(derivedColumnDbName).getPropertyType();
        if (("sum".equalsIgnoreCase(function) || "avg".equalsIgnoreCase(function)) && !Number.class.isAssignableFrom(deriveColumnType)) {
            this.throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, deriveColumnType);
        }
    }

    protected void throwScalarConditionUnmatchedColumnTypeException(String function, String derivedColumnDbName, Class<?> derivedColumnType) {
        this.createCBExThrower().throwScalarConditionUnmatchedColumnTypeException(function, derivedColumnDbName, derivedColumnType);
    }
}

