/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.mapstring;

import java.util.Arrays;
import java.util.List;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.helper.token.line.LineToken;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnMapString {
    protected String _mapMark;
    protected String _startBrace;
    protected String _endBrace;
    protected String _delimiter;
    protected String _equal;
    protected List<String> _columnNameList;

    public String buildMapString(String values, String delimiter) {
        if (values == null) {
            String msg = "The argument[values] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (delimiter == null) {
            String msg = "The argument[delimiter] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.assertStringComponent();
        List<String> valueList = this.tokenize(values, delimiter);
        return this.buildMapString(valueList);
    }

    public String buildMapString(List<String> valueList) {
        if (valueList == null) {
            String msg = "The argument[valueList] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.assertStringComponent();
        this.assertColumnValueList(this._columnNameList, valueList);
        StringBuilder sb = new StringBuilder();
        sb.append(this._mapMark).append(this._startBrace);
        for (int i = 0; i < this._columnNameList.size(); ++i) {
            String columnName = this._columnNameList.get(i);
            String value = valueList.get(i);
            sb.append(columnName).append(this._equal).append(value).append(this._delimiter);
        }
        sb.delete(sb.length() - this._delimiter.length(), sb.length());
        sb.append(this._endBrace);
        return sb.toString();
    }

    protected List<String> tokenize(String value, String delimiter) {
        LineToken lineToken = new LineToken();
        LineTokenizingOption lineTokenizingOption = new LineTokenizingOption();
        lineTokenizingOption.setDelimiter(delimiter);
        return lineToken.tokenize(value, lineTokenizingOption);
    }

    protected void assertStringComponent() {
        if (this._columnNameList == null) {
            String msg = "The columnNameList should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._columnNameList.isEmpty()) {
            String msg = "The columnNameList should not be empty.";
            throw new IllegalStateException(msg);
        }
        if (this._mapMark == null) {
            String msg = "The msMapMark should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._startBrace == null) {
            String msg = "The msStartBrace should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._endBrace == null) {
            String msg = "The msEndBrace should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._delimiter == null) {
            String msg = "The msDelimiter should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._equal == null) {
            String msg = "The msEqual should not be null.";
            throw new IllegalStateException(msg);
        }
    }

    protected void assertColumnValueList(List<String> columnNameList, List<String> valueList) {
        if (columnNameList.size() != valueList.size()) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The length of columnNameList and valueList are different.");
            br.addItem("Column Name List");
            br.addElement(columnNameList.size());
            br.addElement(columnNameList.toString());
            br.addItem("Value List");
            br.addElement(valueList.size());
            br.addElement(valueList.toString());
            String msg = br.buildExceptionMessage();
            throw new DifferentDelimiterCountException(msg, columnNameList, valueList);
        }
    }

    protected final String replace(String str, String fromStr, String toStr) {
        return Srl.replace(str, fromStr, toStr);
    }

    public void setMapMark(String value) {
        this._mapMark = value;
    }

    public void setStartBrace(String value) {
        this._startBrace = value;
    }

    public void setEndBrace(String value) {
        this._endBrace = value;
    }

    public void setDelimiter(String value) {
        this._delimiter = value;
    }

    public void setEqual(String value) {
        this._equal = value;
    }

    public void setColumnNames(String[] columnNames) {
        this._columnNameList = Arrays.asList(columnNames);
    }

    public void setColumnNameList(List<String> columnNameList) {
        this._columnNameList = columnNameList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DifferentDelimiterCountException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected List<String> _columnNameList;
        protected List<String> _valueList;

        public DifferentDelimiterCountException(String msg, List<String> columnNameList, List<String> valueList) {
            super(msg);
            this._columnNameList = columnNameList;
            this._valueList = valueList;
        }

        public List<String> getColumnNameList() {
            return this._columnNameList;
        }

        public List<String> getValueList() {
            return this._valueList;
        }
    }
}

