/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.token.line;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.helper.token.line.LineMakingOption;
import org.seasar.dbflute.helper.token.line.LineTokenizingOption;
import org.seasar.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineToken {
    public List<String> tokenize(String lineString, LineTokenizingOption lineTokenizingOption) {
        String delimiter = lineTokenizingOption.getDelimiter();
        ArrayList<String> list = new ArrayList<String>();
        int elementIndex = 0;
        int delimiterIndex = lineString.indexOf(delimiter);
        while (delimiterIndex >= 0) {
            String value = lineString.substring(elementIndex, delimiterIndex);
            list.add(this.filterHandlingEmptyAsNull(value, lineTokenizingOption));
            elementIndex = delimiterIndex + delimiter.length();
            delimiterIndex = lineString.indexOf(delimiter, elementIndex);
        }
        String lastElement = lineString.substring(elementIndex);
        list.add(this.filterHandlingEmptyAsNull(lastElement, lineTokenizingOption));
        return list;
    }

    protected String filterHandlingEmptyAsNull(String target, LineTokenizingOption lineTokenizingOption) {
        if (target == null) {
            return null;
        }
        if (lineTokenizingOption.isHandleEmtpyAsNull() && "".equals(target)) {
            return null;
        }
        return target;
    }

    public String make(List<String> valueList, LineMakingOption lineMakingOption) {
        this.assertObjectNotNull("valueList", valueList);
        this.assertObjectNotNull("lineMakingOption", lineMakingOption);
        String delimiter = lineMakingOption.getDelimiter();
        this.assertObjectNotNull("lineMakingOption.getDelimiter()", delimiter);
        return this.createLineString(valueList, delimiter, lineMakingOption.isQuoteAll(), lineMakingOption.isQuoteMinimally(), lineMakingOption.isTrimSpace());
    }

    protected String createLineString(List<String> valueList, String delimiter, boolean quoteAll, boolean quoteMinimamlly, boolean trimSpace) {
        StringBuffer sb = new StringBuffer();
        for (String value : valueList) {
            String string = value = value != null ? value : "";
            if (trimSpace) {
                value = value.trim();
            }
            if (quoteAll) {
                value = Srl.replace(value, "\"", "\"\"");
                sb.append(delimiter).append("\"").append(value).append("\"");
                continue;
            }
            if (quoteMinimamlly && this.needsQuote(value, delimiter)) {
                value = Srl.replace(value, "\"", "\"\"");
                sb.append(delimiter).append("\"").append(value).append("\"");
                continue;
            }
            sb.append(delimiter).append(value);
        }
        sb.delete(0, delimiter.length());
        return sb.toString();
    }

    protected boolean needsQuote(String value, String delimiter) {
        return value.contains("\"") || value.contains("\r") || value.contains("\n") || value.contains(delimiter);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }
}

