/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnAbstractEntityHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractEntityStaticCommand
extends TnAbstractBasicSqlCommand {
    protected final TnBeanMetaData _beanMetaData;
    protected final DBMeta _targetDBMeta;
    protected final boolean _optimisticLockHandling;
    protected final boolean _versionNoAutoIncrementOnMemory;
    protected TnPropertyType[] _propertyTypes;
    protected String _sql;

    public TnAbstractEntityStaticCommand(DataSource dataSource, StatementFactory statementFactory, TnBeanMetaData beanMetaData, DBMeta targetDBMeta, String[] propertyNames, boolean optimisticLockHandling, boolean versionNoAutoIncrementOnMemory) {
        super(dataSource, statementFactory);
        this.assertObjectNotNull("targetDBMeta", targetDBMeta);
        this.assertObjectNotNull("propertyNames", propertyNames);
        this._targetDBMeta = targetDBMeta;
        this._optimisticLockHandling = optimisticLockHandling;
        this._versionNoAutoIncrementOnMemory = versionNoAutoIncrementOnMemory;
        this._beanMetaData = beanMetaData;
        this.setupPropertyTypes(propertyNames);
        this.setupSql();
    }

    @Override
    public Object execute(Object[] args) {
        TnAbstractEntityHandler handler = this.createEntityHandler(args);
        return this.doExecute(args, handler);
    }

    protected Object doExecute(Object[] args, TnAbstractEntityHandler handler) {
        handler.setExceptionMessageSqlArgs(args);
        int rows = handler.execute(args);
        return rows;
    }

    protected TnAbstractEntityHandler createEntityHandler(Object[] args) {
        TnAbstractEntityHandler handler = this.newEntityHandler();
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setExceptionMessageSqlArgs(args);
        return handler;
    }

    protected abstract TnAbstractEntityHandler newEntityHandler();

    protected void setupPropertyTypes(String[] propertyNames) {
        this._propertyTypes = new TnPropertyType[0];
    }

    protected abstract void setupSql();

    protected void setupDeleteSql() {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(64);
        sb.append("delete from ").append(this._targetDBMeta.getTableSqlName());
        this.setupDeleteWhere(sb);
        this._sql = sb.toString();
    }

    protected void checkPrimaryKey() {
        TnBeanMetaData bmd = this._beanMetaData;
        if (bmd.getPrimaryKeySize() == 0) {
            String msg = "The primary key was not found:";
            msg = msg + " bean=" + bmd.getBeanClass();
            throw new IllegalStateException(msg);
        }
    }

    protected void setupDeleteWhere(StringBuilder sb) {
        TnBeanMetaData bmd = this._beanMetaData;
        sb.append(" where ");
        for (int i = 0; i < bmd.getPrimaryKeySize(); ++i) {
            sb.append(bmd.getPrimaryKeySqlName(i)).append(" = ? and ");
        }
        sb.setLength(sb.length() - 5);
        if (this._optimisticLockHandling && bmd.hasVersionNoPropertyType()) {
            TnPropertyType pt = bmd.getVersionNoPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
        if (this._optimisticLockHandling && bmd.hasTimestampPropertyType()) {
            TnPropertyType pt = bmd.getTimestampPropertyType();
            sb.append(" and ").append(pt.getColumnSqlName()).append(" = ?");
        }
    }

    protected DeleteOption<ConditionBean> extractDeleteOption(Object[] args) {
        if (args.length < 2 || args[1] == null) {
            return null;
        }
        DeleteOption option = (DeleteOption)args[1];
        return option;
    }
}

