/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.PlusMult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseVector
extends AbstractVector {
    protected double[] values;

    public DenseVector() {
    }

    public DenseVector(String name) {
        super(name);
    }

    public DenseVector(double[] values) {
        this(values, false);
    }

    public DenseVector(double[] values, boolean shallowCopy) {
        this.values = shallowCopy ? values : (double[])values.clone();
    }

    public DenseVector(DenseVector values, boolean shallowCopy) {
        this(values.values, shallowCopy);
    }

    public DenseVector(String name, double[] values) {
        super(name);
        this.values = (double[])values.clone();
    }

    public DenseVector(int cardinality) {
        this(null, cardinality);
    }

    public DenseVector(String name, int cardinality) {
        super(name);
        this.values = new double[cardinality];
    }

    public DenseVector(Vector vector) {
        super(vector.getName());
        this.values = new double[vector.size()];
        Iterator<Vector.Element> it = vector.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            this.values[e.index()] = e.get();
        }
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public DenseVector clone() {
        DenseVector clone = (DenseVector)super.clone();
        clone.values = (double[])this.values.clone();
        return clone;
    }

    @Override
    public double getQuick(int index) {
        return this.values[index];
    }

    @Override
    public DenseVector like() {
        DenseVector denseVector = new DenseVector(this.size());
        denseVector.setLabelBindings(this.getLabelBindings());
        return denseVector;
    }

    @Override
    public Vector like(int cardinality) {
        DenseVector denseVector = new DenseVector(cardinality);
        denseVector.setLabelBindings(this.getLabelBindings());
        return denseVector;
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values[index] = value;
    }

    @Override
    public Vector assign(double value) {
        this.lengthSquared = -1.0;
        Arrays.fill(this.values, value);
        return this;
    }

    @Override
    public Vector assign(Vector other, BinaryFunction function) {
        if (other.size() != this.size()) {
            throw new CardinalityException();
        }
        if (function instanceof PlusMult) {
            Vector.Element e;
            Iterator<Vector.Element> it = other.iterateNonZero();
            while (it.hasNext() && (e = it.next()) != null) {
                this.values[e.index()] = function.apply(this.values[e.index()], e.get());
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.values[i] = function.apply(this.values[i], other.getQuick(i));
            }
        }
        this.lengthSquared = -1.0;
        return this;
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.length;
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (length > this.values.length) {
            throw new CardinalityException();
        }
        if (offset < 0 || offset + length > this.values.length) {
            throw new IndexException();
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonZeroIterator();
    }

    @Override
    public Iterator<Vector.Element> iterateAll() {
        return new AllIterator();
    }

    @Override
    public Vector.Element getElement(int index) {
        return new Element(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector that = (Vector)o;
        String thisName = this.getName();
        String thatName = that.getName();
        if (this.size() != that.size()) {
            return false;
        }
        if (thisName != null && thatName != null && !thisName.equals(thatName)) {
            return false;
        }
        if (thisName != null && thatName == null || thatName != null && thisName == null) {
            return false;
        }
        if (that instanceof DenseVector) {
            return Arrays.equals(this.values, ((DenseVector)that).values);
        }
        return DenseVector.equivalent(this, that);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        double result = 0.0;
        for (double value : this.values) {
            result += value * value;
        }
        this.lengthSquared = result;
        return result;
    }

    @Override
    public void addTo(Vector v) {
        if (v.size() != this.size()) {
            throw new CardinalityException();
        }
        for (int i = 0; i < this.values.length; ++i) {
            v.setQuick(i, this.values[i] + v.getQuick(i));
        }
    }

    public void addAll(Vector v) {
        if (v.size() != this.size()) {
            throw new CardinalityException();
        }
        Iterator<Vector.Element> iter = v.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            int n = element.index();
            this.values[n] = this.values[n] + element.get();
        }
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        if (x instanceof DenseVector) {
            for (int i = 0; i < x.size(); ++i) {
                result += this.values[i] * x.getQuick(i);
            }
            return result;
        }
        Iterator<Vector.Element> iter = x.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * this.values[element.index()];
        }
        return result;
    }

    public class Element
    implements Vector.Element {
        private int ind;

        public Element(int ind) {
            this.ind = ind;
        }

        public double get() {
            return DenseVector.this.values[this.ind];
        }

        public int index() {
            return this.ind;
        }

        public void set(double value) {
            DenseVector.this.lengthSquared = -1.0;
            DenseVector.this.values[this.ind] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllIterator
    implements Iterator<Vector.Element> {
        private final Element element;

        private AllIterator() {
            this.element = new Element(-1);
        }

        @Override
        public boolean hasNext() {
            return this.element.ind + 1 < DenseVector.this.values.length;
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.ind++;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonZeroIterator
    implements Iterator<Vector.Element> {
        private final Element element;
        private int offset;

        private NonZeroIterator() {
            this.element = new Element(0);
            this.goToNext();
        }

        private void goToNext() {
            while (this.offset < DenseVector.this.values.length && DenseVector.this.values[this.offset] == 0.0) {
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.offset < DenseVector.this.values.length;
        }

        @Override
        public Vector.Element next() {
            if (this.offset >= DenseVector.this.values.length) {
                throw new NoSuchElementException();
            }
            this.element.ind = this.offset;
            ++this.offset;
            this.goToNext();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

