/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.IntDoubleProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntDoubleHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_SIZE = 11;
    protected OpenIntDoubleHashMap values;

    public RandomAccessSparseVector() {
    }

    public RandomAccessSparseVector(int cardinality) {
        this(null, cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int size) {
        this(null, cardinality, size);
    }

    public RandomAccessSparseVector(String name, int cardinality) {
        this(name, cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(String name, int cardinality, int size) {
        super(name, cardinality);
        this.values = new OpenIntDoubleHashMap(size);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.getName(), other.size(), other.getNumNondefaultElements());
        Vector.Element e;
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.values.put(e.index(), e.get());
        }
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.getName(), other.size());
        this.values = shallowCopy ? other.values : (OpenIntDoubleHashMap)other.values.clone();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        int[] cardinality = new int[]{rows, columns};
        return new SparseRowMatrix(cardinality);
    }

    @Override
    public RandomAccessSparseVector clone() {
        RandomAccessSparseVector clone = (RandomAccessSparseVector)super.clone();
        clone.values = (OpenIntDoubleHashMap)this.values.clone();
        return clone;
    }

    @Override
    public Vector assign(Vector other) {
        Vector.Element e;
        if (other.size() != this.size()) {
            throw new CardinalityException();
        }
        this.values.clear();
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.setQuick(e.index(), e.get());
        }
        return this;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values.put(index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.size();
    }

    @Override
    public RandomAccessSparseVector like() {
        int numValues = 256;
        if (this.values != null) {
            numValues = this.values.size();
        }
        return new RandomAccessSparseVector(this.size(), numValues);
    }

    @Override
    public Vector like(int newCardinality) {
        int numValues = 256;
        if (this.values != null) {
            numValues = this.values.size();
        }
        return new RandomAccessSparseVector(newCardinality, numValues);
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonZeroIterator(false);
    }

    @Override
    public Iterator<Vector.Element> iterateAll() {
        return new AllIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector that = (Vector)o;
        String thisName = this.getName();
        String thatName = that.getName();
        if (this.size() != that.size()) {
            return false;
        }
        if (thisName != null && thatName != null && !thisName.equals(thatName)) {
            return false;
        }
        if (thisName != null && thatName == null || thatName != null && thisName == null) {
            return false;
        }
        return RandomAccessSparseVector.equivalent(this, that);
    }

    @Override
    public Vector.Element getElement(int index) {
        return new Element(index);
    }

    @Override
    public void addTo(Vector v) {
        if (v.size() != this.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        this.values.forEachPair((IntDoubleProcedure)new AddToVector(v));
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        if (x instanceof SequentialAccessSparseVector) {
            Iterator<Vector.Element> iter = x.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element element = iter.next();
                result += element.get() * this.getQuick(element.index());
            }
            return result;
        }
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    private static class AddToVector
    implements IntDoubleProcedure {
        private final Vector v;

        private AddToVector(Vector v) {
            this.v = v;
        }

        public boolean apply(int key, double value) {
            this.v.set(key, value + this.v.get(key));
            return true;
        }
    }

    public class Element
    implements Vector.Element {
        private int ind;

        public Element(int ind) {
            this.ind = ind;
        }

        public double get() {
            return RandomAccessSparseVector.this.values.get(this.ind);
        }

        public int index() {
            return this.ind;
        }

        public void set(double value) {
            RandomAccessSparseVector.this.lengthSquared = -1.0;
            RandomAccessSparseVector.this.values.put(this.ind, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonZeroIterator
    implements Iterator<Vector.Element> {
        private int offset = 0;
        private final Element element = new Element(0);
        private final IntArrayList intArrList;

        private NonZeroIterator(boolean sorted) {
            this.intArrList = RandomAccessSparseVector.this.values.keys();
            if (sorted) {
                this.intArrList.sort();
            }
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.intArrList.size();
        }

        @Override
        public Element next() {
            if (this.offset < this.intArrList.size()) {
                this.element.ind = this.intArrList.get(this.offset++);
                return this.element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllIterator
    implements Iterator<Vector.Element> {
        private int offset = 0;
        private final Element element = new Element(0);

        private AllIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.offset < RandomAccessSparseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (this.offset >= RandomAccessSparseVector.this.size()) {
                throw new NoSuchElementException();
            }
            this.element.ind = this.offset++;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

