/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.math;

import java.util.Date;
import org.apache.mahout.math.function.IntFunction;
import org.apache.mahout.math.function.IntIntFunction;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;

@Deprecated
public class IntFunctions {
    public static final IntFunction abs = new IntFunction(){

        public int apply(int a) {
            return a < 0 ? -a : a;
        }
    };
    public static final IntFunction identity = new IntFunction(){

        public int apply(int a) {
            return a;
        }
    };
    public static final IntFunction not = new IntFunction(){

        public int apply(int a) {
            return ~a;
        }
    };
    public static final IntFunction sign = new IntFunction(){

        public int apply(int a) {
            return a < 0 ? -1 : (a > 0 ? 1 : 0);
        }
    };
    public static final IntFunction square = new IntFunction(){

        public int apply(int a) {
            return a * a;
        }
    };
    public static final IntIntFunction and = new IntIntFunction(){

        public int apply(int a, int b) {
            return a & b;
        }
    };
    public static final IntIntFunction compare = new IntIntFunction(){

        public int apply(int a, int b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    };
    public static final IntIntFunction div = new IntIntFunction(){

        public int apply(int a, int b) {
            return a / b;
        }
    };
    public static final IntIntFunction equals = new IntIntFunction(){

        public int apply(int a, int b) {
            return a == b ? 1 : 0;
        }
    };
    public static final IntIntFunction max = new IntIntFunction(){

        public int apply(int a, int b) {
            return a >= b ? a : b;
        }
    };
    public static final IntIntFunction min = new IntIntFunction(){

        public int apply(int a, int b) {
            return a <= b ? a : b;
        }
    };
    public static final IntIntFunction minus = new IntIntFunction(){

        public int apply(int a, int b) {
            return a - b;
        }
    };
    public static final IntIntFunction mult = new IntIntFunction(){

        public int apply(int a, int b) {
            return a * b;
        }
    };
    public static final IntIntFunction or = new IntIntFunction(){

        public int apply(int a, int b) {
            return a | b;
        }
    };
    public static final IntIntFunction plus = new IntIntFunction(){

        public int apply(int a, int b) {
            return a + b;
        }
    };
    public static final IntIntFunction pow = new IntIntFunction(){

        public int apply(int a, int b) {
            return (int)Math.pow(a, b);
        }
    };

    private IntFunctions() {
    }

    public static IntFunction and(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a & b;
            }
        };
    }

    public static IntFunction between(final int from, final int to) {
        return new IntFunction(){

            public int apply(int a) {
                return from <= a && a <= to ? 1 : 0;
            }
        };
    }

    public static IntFunction chain(final IntFunction g, final IntFunction h) {
        return new IntFunction(){

            public int apply(int a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static IntIntFunction chain(final IntFunction g, final IntIntFunction h) {
        return new IntIntFunction(){

            public int apply(int a, int b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static IntIntFunction chain(final IntIntFunction f, final IntFunction g, final IntFunction h) {
        return new IntIntFunction(){

            public int apply(int a, int b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static IntFunction compare(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a < b ? -1 : (a > b ? 1 : 0);
            }
        };
    }

    public static IntFunction constant(final int c) {
        return new IntFunction(){

            public int apply(int a) {
                return c;
            }
        };
    }

    public static IntFunction div(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a / b;
            }
        };
    }

    public static IntFunction equals(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a == b ? 1 : 0;
            }
        };
    }

    public static IntFunction max(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a >= b ? a : b;
            }
        };
    }

    public static IntFunction min(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a <= b ? a : b;
            }
        };
    }

    public static IntFunction minus(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a - b;
            }
        };
    }

    public static IntFunction mult(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a * b;
            }
        };
    }

    public static IntFunction or(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a | b;
            }
        };
    }

    public static IntFunction plus(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return a + b;
            }
        };
    }

    public static IntFunction pow(final int b) {
        return new IntFunction(){

            public int apply(int a) {
                return (int)Math.pow(a, b);
            }
        };
    }

    public static IntFunction random() {
        return new MersenneTwister(new Date());
    }
}

