/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;
import org.apache.mahout.math.jet.random.Gamma;
import org.apache.mahout.math.jet.random.Poisson;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.stat.Probability;

@Deprecated
public class NegativeBinomial
extends AbstractDiscreteDistribution {
    private int n;
    private double p;
    private Gamma gamma;
    private Poisson poisson;
    private static final NegativeBinomial shared = new NegativeBinomial(1, 0.5, NegativeBinomial.makeDefaultGenerator());

    public NegativeBinomial(int n, double p, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setNandP(n, p);
        this.gamma = new Gamma(n, 1.0, randomGenerator);
        this.poisson = new Poisson(0.0, randomGenerator);
    }

    public double cdf(int k) {
        return Probability.negativeBinomial(k, this.n, this.p);
    }

    public Object clone() {
        NegativeBinomial copy = (NegativeBinomial)super.clone();
        if (this.poisson != null) {
            copy.poisson = (Poisson)this.poisson.clone();
        }
        copy.poisson.setRandomGenerator(copy.getRandomGenerator());
        if (this.gamma != null) {
            copy.gamma = (Gamma)this.gamma.clone();
        }
        copy.gamma.setRandomGenerator(copy.getRandomGenerator());
        return copy;
    }

    public int nextInt() {
        return this.nextInt(this.n, this.p);
    }

    public int nextInt(int n, double p) {
        double x = p / (1.0 - p);
        double y = x * this.gamma.nextDouble(n, 1.0);
        return this.poisson.nextInt(y);
    }

    public double pdf(int k) {
        if (k > this.n) {
            throw new IllegalArgumentException();
        }
        return Arithmetic.binomial(this.n, (long)k) * Math.pow(this.p, k) * Math.pow(1.0 - this.p, this.n - k);
    }

    public void setNandP(int n, double p) {
        this.n = n;
        this.p = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(int n, double p) {
        NegativeBinomial negativeBinomial = shared;
        synchronized (negativeBinomial) {
            return shared.nextInt(n, p);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.n + ',' + this.p + ')';
    }
}

