/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat.quantile;

import java.util.Arrays;
import org.apache.mahout.math.PersistentObject;

@Deprecated
public class EquiDepthHistogram
extends PersistentObject {
    private final float[] binBoundaries;

    public EquiDepthHistogram(float[] quantileElements) {
        this.binBoundaries = quantileElements;
    }

    public int binOfElement(float element) {
        int index = Arrays.binarySearch(this.binBoundaries, element);
        if (index >= 0) {
            if (index == this.binBoundaries.length - 1) {
                --index;
            }
        } else {
            if (++index == 0 || index == this.binBoundaries.length) {
                throw new IllegalArgumentException("Element=" + element + " not contained in any bin.");
            }
            --index;
        }
        return index;
    }

    public int bins() {
        return this.binBoundaries.length - 1;
    }

    public float endOfBin(int binIndex) {
        return this.binBoundaries[binIndex + 1];
    }

    public double percentFromTo(float from, float to) {
        return this.phi(to) - this.phi(from);
    }

    public double phi(float element) {
        int size = this.binBoundaries.length;
        if (element <= this.binBoundaries[0]) {
            return 0.0;
        }
        if (element >= this.binBoundaries[size - 1]) {
            return 1.0;
        }
        double binWidth = 1.0 / (double)(size - 1);
        int index = Arrays.binarySearch(this.binBoundaries, element);
        if (index >= 0) {
            return binWidth * (double)index;
        }
        int insertionPoint = -index - 1;
        double from = this.binBoundaries[insertionPoint - 1];
        double to = (double)this.binBoundaries[insertionPoint] - from;
        double p = ((double)element - from) / to;
        return binWidth * (p + (double)(insertionPoint - 1));
    }

    @Deprecated
    public int size() {
        return this.binBoundaries.length;
    }

    public float startOfBin(int binIndex) {
        return this.binBoundaries[binIndex];
    }
}

