/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.doublealgo;

import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleComparator;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.DoubleMatrix3D;
import org.apache.mahout.math.matrix.doublealgo.DoubleMatrix1DComparator;
import org.apache.mahout.math.matrix.doublealgo.DoubleMatrix2DComparator;
import org.apache.mahout.math.matrix.impl.AbstractFormatter;

@Deprecated
public class Sorting
extends PersistentObject {
    public static final Sorting quickSort = new Sorting();
    public static final Sorting mergeSort = new Sorting(){

        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            org.apache.mahout.math.Sorting.mergeSort((int[])a, (int)fromIndex, (int)toIndex, (IntComparator)c);
        }

        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            org.apache.mahout.math.Sorting.mergeSort((int)fromIndex, (int)toIndex, (IntComparator)c, (Swapper)swapper);
        }
    };

    protected Sorting() {
    }

    private static int compareNaN(double a, double b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        org.apache.mahout.math.Sorting.quickSort((int[])a, (int)fromIndex, (int)toIndex, (IntComparator)c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        org.apache.mahout.math.Sorting.quickSort((int)fromIndex, (int)toIndex, (IntComparator)c, (Swapper)swapper);
    }

    public DoubleMatrix1D sort(final DoubleMatrix1D vector) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = vector.getQuick(a);
                double bv = vector.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public DoubleMatrix1D sort(final DoubleMatrix1D vector, final DoubleComparator c) {
        int[] indexes = new int[vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(vector.getQuick(a), vector.getQuick(b));
            }
        };
        this.runSort(indexes, 0, indexes.length, comp);
        return vector.viewSelection(indexes);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final double[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int x, int y) {
                double a = aggregates[x];
                double b = aggregates[y];
                if (a != a || b != b) {
                    return Sorting.compareNaN(a, b);
                }
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                double t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = col.getQuick(a);
                double bv = col.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix2D sort(DoubleMatrix2D matrix, final DoubleMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final DoubleMatrix1D[] views = new DoubleMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                double av = sliceView.getQuick(a);
                double bv = sliceView.getQuick(b);
                if (av != av || bv != bv) {
                    return Sorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public DoubleMatrix3D sort(DoubleMatrix3D matrix, final DoubleMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final DoubleMatrix2D[] views = new DoubleMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }
}

