/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh3Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int[] ConstOffHiLen = PostLh3Encoder.createConstOffHiLen();
    private static final int CodeSize = 286;
    private BitOutputStream out;
    private byte[] buffer;
    private int blockSize;
    private int position;
    private int flagBit;
    private int flagPos;
    private int[] codeFreq;
    private int[] offHiFreq;

    private PostLh3Encoder() {
    }

    public PostLh3Encoder(OutputStream outputStream) {
        this(outputStream, 16384);
    }

    public PostLh3Encoder(OutputStream outputStream, int n) {
        if (outputStream == null || 25 > n) {
            if (outputStream == null) {
                throw new NullPointerException("out");
            }
            throw new IllegalArgumentException("BufferSize too small. BufferSize must be larger than 25");
        }
        this.out = outputStream instanceof BitOutputStream ? (BitOutputStream)outputStream : new BitOutputStream(outputStream);
        this.codeFreq = new int[286];
        this.offHiFreq = new int[128];
        this.buffer = new byte[n];
        this.blockSize = 0;
        this.position = 0;
        this.flagBit = 0;
        this.flagPos = 0;
    }

    public void writeCode(int n) throws IOException {
        if (this.flagBit == 0) {
            if (this.buffer.length - this.position < 25 || 65528 <= this.blockSize) {
                this.writeOut();
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.buffer[this.flagPos] = 0;
        }
        this.buffer[this.position++] = (byte)n;
        if (256 <= n) {
            int n2 = this.flagPos;
            this.buffer[n2] = (byte)(this.buffer[n2] | this.flagBit);
        }
        this.flagBit >>= 1;
        int n3 = Math.min(n, 285);
        this.codeFreq[n3] = this.codeFreq[n3] + 1;
        ++this.blockSize;
    }

    public void writeOffset(int n) {
        this.buffer[this.position++] = (byte)(n >> 8);
        this.buffer[this.position++] = (byte)n;
        int n2 = n >> 6;
        this.offHiFreq[n2] = this.offHiFreq[n2] + 1;
    }

    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.buffer = null;
        this.codeFreq = null;
        this.offHiFreq = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }

    private void writeOut() throws IOException {
        if (0 < this.blockSize) {
            int n;
            this.out.writeBits(16, this.blockSize);
            int[] nArray = StaticHuffman.FreqListToLenList(this.codeFreq);
            int[] nArray2 = StaticHuffman.LenListToCodeList(nArray);
            int[] nArray3 = PostLh3Encoder.getBetterOffHiLen(this.offHiFreq, StaticHuffman.FreqListToLenList(this.offHiFreq));
            int[] nArray4 = StaticHuffman.LenListToCodeList(nArray3);
            if (2 <= PostLh3Encoder.countNoZeroElement(this.codeFreq)) {
                this.writeCodeLenList(nArray);
            } else {
                this.out.writeBits(15, 16912);
                this.out.writeBits(9, PostLh3Encoder.getNoZeroElementIndex(this.codeFreq));
            }
            if (nArray3 != ConstOffHiLen) {
                this.out.writeBit(1);
                if (2 <= PostLh3Encoder.countNoZeroElement(this.offHiFreq)) {
                    this.writeOffHiLenList(nArray3);
                } else {
                    this.out.writeBits(12, 273);
                    this.out.writeBits(7, PostLh3Encoder.getNoZeroElementIndex(this.offHiFreq));
                }
            } else {
                this.out.writeBit(0);
            }
            this.position = 0;
            this.flagBit = 0;
            for (n = 0; n < this.blockSize; ++n) {
                int n2;
                if (this.flagBit == 0) {
                    this.flagBit = 128;
                    ++this.position;
                    this.flagPos = this.flagPos;
                }
                if (0 == (this.buffer[this.flagPos] & this.flagBit)) {
                    n2 = this.buffer[this.position++] & 0xFF;
                    this.out.writeBits(nArray[n2], nArray2[n2]);
                } else {
                    n2 = this.buffer[this.position++] & 0xFF | 0x100;
                    int n3 = (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
                    int n4 = n3 >> 6;
                    if (n2 < 285) {
                        this.out.writeBits(nArray[n2], nArray2[n2]);
                    } else {
                        this.out.writeBits(nArray[285], nArray2[285]);
                        this.out.writeBits(8, n2 - 285);
                    }
                    this.out.writeBits(nArray3[n4], nArray4[n4]);
                    this.out.writeBits(6, n3);
                }
                this.flagBit >>= 1;
            }
            for (n = 0; n < this.codeFreq.length; ++n) {
                this.codeFreq[n] = 0;
            }
            for (n = 0; n < this.offHiFreq.length; ++n) {
                this.offHiFreq[n] = 0;
            }
            this.blockSize = 0;
            this.position = 0;
            this.flagBit = 0;
        }
    }

    private void writeCodeLenList(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            if (0 < nArray[i]) {
                this.out.writeBits(5, 0x10 | nArray[i] - 1);
                continue;
            }
            this.out.writeBit(0);
        }
    }

    private void writeOffHiLenList(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.out.writeBits(4, nArray[i]);
        }
    }

    private static int countNoZeroElement(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (0 == nArray[i]) continue;
            ++n;
        }
        return n;
    }

    private static int getNoZeroElementIndex(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (0 == nArray[i]) continue;
            return i;
        }
        return 0;
    }

    private static int[] createConstOffHiLen() {
        int[] nArray = new int[]{2, 1, 1, 3, 6, 13, 31, 78, 0};
        int[] nArray2 = new int[128];
        int n = 0;
        int n2 = nArray[n++];
        for (int i = 0; i < 128; ++i) {
            while (nArray[n] == i) {
                ++n2;
                ++n;
            }
            nArray2[i] = n2;
        }
        return nArray2;
    }

    private static int[] getBetterOffHiLen(int[] nArray, int[] nArray2) {
        int n;
        boolean bl = false;
        for (n = 0; n < nArray2.length; ++n) {
            if (15 >= nArray2[n]) continue;
            bl = true;
        }
        if (!bl) {
            n = 1;
            int n2 = 1;
            n = 2 <= PostLh3Encoder.countNoZeroElement(nArray) ? (n += 512) : (n += 19);
            for (int i = 0; i < nArray.length; ++i) {
                n += nArray[i] * nArray2[i];
                n2 += nArray[i] * ConstOffHiLen[i];
            }
            if (n < n2) {
                return nArray2;
            }
            return ConstOffHiLen;
        }
        return ConstOffHiLen;
    }
}

