/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.builder.impl;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.builder.MobyletMailBuilder;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.message.MobyletMessage;
import org.mobylet.mail.util.DataHandlerUtils;
import org.mobylet.mail.util.PartUtils;

public class MobyletTextMailBuilder
implements MobyletMailBuilder,
MailConstants {
    @Override
    public MobyletMessage build(MobyletMessage message) {
        if (message.getBody().getAttaches().size() == 0) {
            return this.buildSimpleTextMail(message);
        }
        return this.buildAttachedTextMail(message);
    }

    public MobyletMessage buildSimpleTextMail(MobyletMessage message) {
        return this.buildTextPart(message, message.getCarrier(), message.getBody().getText(), message.getNotifyCharset());
    }

    public MobyletMessage buildAttachedTextMail(MobyletMessage message) {
        MimeMultipart multipart = this.createAttachMultipart(message.getCarrier());
        MimeBodyPart part = this.buildTextPart(new MimeBodyPart(), message.getCarrier(), message.getBody().getText(), message.getNotifyCharset());
        try {
            multipart.addBodyPart((BodyPart)part);
            for (MessageBody.Attach attach : message.getBody().getAttaches()) {
                multipart.addBodyPart((BodyPart)PartUtils.buildAttachPart(message.getCarrier(), attach));
            }
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        try {
            message.setContent((Multipart)multipart);
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        return message;
    }

    public <M extends MimePart> M buildTextPart(M part, Carrier carrier, String text, String notifyCharset) {
        try {
            part.setDataHandler(DataHandlerUtils.getDataHandler(carrier, text));
            part.addHeader("Content-Transfer-Encoding", "7bit");
            part.addHeader("Content-Type", "text/plain; charset=\"" + notifyCharset + "\"");
            return part;
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30d1\u30fc\u30c8\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Exception)((Object)e));
        }
    }

    public MimeMultipart createAttachMultipart(Carrier carrier) {
        MimeMultipart multiPart = new MimeMultipart();
        try {
            switch (carrier) {
                case DOCOMO: 
                case AU: 
                case OTHER: {
                    multiPart.setSubType("mixed");
                    break;
                }
                case SOFTBANK: {
                    multiPart.setSubType("related");
                }
            }
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("Multipart\u304c\u4f5c\u6210\u51fa\u6765\u307e\u305b\u3093", (Exception)((Object)e));
        }
        return multiPart;
    }
}

