/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.message;

import java.nio.charset.Charset;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.builder.MobyletMailBuilder;
import org.mobylet.mail.builder.impl.MobyletDecoMailBuilder;
import org.mobylet.mail.builder.impl.MobyletHtmlMailBuilder;
import org.mobylet.mail.builder.impl.MobyletTextMailBuilder;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.selector.MailCharsetSelector;
import org.mobylet.mail.util.DataHandlerUtils;
import org.mobylet.mail.util.MailHeaderUtils;

public class MobyletMessage
extends MimeMessage
implements MailConstants {
    protected Carrier carrier;
    protected Charset encodingCharset;
    protected String notifyCharset;
    protected Session mobyletSession;
    protected MessageBody body;
    protected boolean isConstructed;

    public MobyletMessage(Carrier toCarrier, Session session) {
        super(session);
        this.carrier = toCarrier;
        MailCharsetSelector charsetSelector = (MailCharsetSelector)SingletonUtils.get(MailCharsetSelector.class);
        this.encodingCharset = charsetSelector.getEncodingCharset(this.carrier);
        this.notifyCharset = charsetSelector.getNotifyCharset(this.carrier);
        this.mobyletSession = session;
    }

    public MobyletMessage from(String address) {
        return this.from(address, null);
    }

    public MobyletMessage from(String address, String principal) {
        try {
            InternetAddress adrs = StringUtils.isEmpty((String)principal) ? new InternetAddress(address) : new InternetAddress(address, principal, this.notifyCharset);
            this.setFrom((Address)adrs);
            return this;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("FROM\u306e\u8a2d\u5b9a\u306b\u5931\u6557 address = " + address, e);
        }
    }

    public MobyletMessage to(String address) {
        return this.to(address, null);
    }

    public MobyletMessage to(String address, String principal) {
        try {
            return this.addRecipient(address, principal, MimeMessage.RecipientType.TO);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("TO\u306e\u8a2d\u5b9a\u306b\u5931\u6557 address = " + address, e);
        }
    }

    public MobyletMessage cc(String address) {
        return this.cc(address, null);
    }

    public MobyletMessage cc(String address, String principal) {
        try {
            return this.addRecipient(address, principal, MimeMessage.RecipientType.CC);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("CC\u306e\u8a2d\u5b9a\u306b\u5931\u6557 address = " + address, e);
        }
    }

    public MobyletMessage bcc(String address) {
        return this.bcc(address, null);
    }

    public MobyletMessage bcc(String address, String principal) {
        try {
            return this.addRecipient(address, principal, MimeMessage.RecipientType.BCC);
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("BCC\u306e\u8a2d\u5b9a\u306b\u5931\u6557 address = " + address, e);
        }
    }

    public MobyletMessage addRecipient(String address, String principal, Message.RecipientType type) throws Exception {
        InternetAddress adrs = StringUtils.isEmpty((String)principal) ? new InternetAddress(address) : new InternetAddress(address, principal, this.notifyCharset);
        this.addRecipient(type, (Address)adrs);
        return this;
    }

    public void setSubject(String subject) throws MessagingException {
        this.subject(subject);
    }

    public MobyletMessage subject(String string) {
        String headerMessage = "";
        try {
            headerMessage = MailHeaderUtils.encodeHeaderString(this.carrier, string);
            super.setSubject(headerMessage);
            return this;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("SUBJECT\u306e\u8a2d\u5b9a\u306b\u5931\u6557 string = " + string, e);
        }
    }

    public MobyletMessage setBody(MessageBody body) {
        this.body = body;
        return this;
    }

    public MessageBody getBody() {
        return this.body;
    }

    public MobyletMessage construct() {
        if (this.isConstructed || this.body == null) {
            return this;
        }
        MobyletMailBuilder builder = null;
        builder = StringUtils.isNotEmpty((String)this.body.getText()) && StringUtils.isEmpty((String)this.body.getHtml()) ? (MobyletMailBuilder)SingletonUtils.get(MobyletTextMailBuilder.class) : (StringUtils.isEmpty((String)this.body.getText()) && StringUtils.isNotEmpty((String)this.body.getHtml()) ? (MobyletMailBuilder)SingletonUtils.get(MobyletHtmlMailBuilder.class) : (MobyletMailBuilder)SingletonUtils.get(MobyletDecoMailBuilder.class));
        this.isConstructed = true;
        return builder.build(this);
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public Charset getEncodingCharset() {
        return this.encodingCharset;
    }

    public String getNotifyCharset() {
        return this.notifyCharset;
    }

    public Session getSession() {
        return this.mobyletSession;
    }

    public MobyletMessage setTextBody(String source) {
        try {
            this.setDataHandler(DataHandlerUtils.getDataHandler(this.carrier, source));
            this.addHeader("Content-Transfer-Encoding", "7bit");
            this.addHeader("Content-Type", "text/plain; charset=\"" + this.notifyCharset + "\"");
            return this;
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30d1\u30fc\u30c8\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Exception)((Object)e));
        }
    }

    public MobyletMessage setHtmlBody(String source) {
        try {
            this.setDataHandler(DataHandlerUtils.getDataHandler(this.carrier, source));
            this.addHeader("Content-Transfer-Encoding", "7bit");
            this.addHeader("Content-Type", "text/html; charset=\"" + this.notifyCharset + "\"");
            return this;
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30d1\u30fc\u30c8\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Exception)((Object)e));
        }
    }
}

