/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.DIHPropertiesWriter;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePropertiesWriter
implements DIHPropertiesWriter {
    private static final Logger log = LoggerFactory.getLogger(SimplePropertiesWriter.class);
    static final String IMPORTER_PROPERTIES = "dataimport.properties";
    static final String LAST_INDEX_KEY = "last_index_time";
    private String persistFilename = "dataimport.properties";
    private String configDir = null;

    public void init(DataImporter dataImporter) {
        SolrCore core = dataImporter.getCore();
        String configDir = core == null ? "." : core.getResourceLoader().getConfigDir();
        String persistFileName = dataImporter.getHandlerName();
        this.configDir = configDir;
        if (persistFileName != null) {
            this.persistFilename = persistFileName + ".properties";
        }
    }

    private File getPersistFile() {
        String filePath = this.configDir;
        if (this.configDir != null && !this.configDir.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        filePath = filePath + this.persistFilename;
        return new File(filePath);
    }

    public boolean isWritable() {
        File persistFile = this.getPersistFile();
        return persistFile.exists() ? persistFile.canWrite() : persistFile.getParentFile().canWrite();
    }

    /*
     * Loose catch block
     */
    public void persist(Properties p) {
        block10: {
            OutputStream propOutput = null;
            Properties props = this.readIndexerProperties();
            props.putAll((Map<?, ?>)p);
            String filePath = this.configDir;
            if (this.configDir != null && !this.configDir.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            filePath = filePath + this.persistFilename;
            propOutput = new FileOutputStream(filePath);
            props.store(propOutput, null);
            log.info("Wrote last indexed time to " + this.persistFilename);
            Object var6_6 = null;
            try {
                if (propOutput != null) {
                    propOutput.close();
                }
                break block10;
            }
            catch (IOException e) {
                propOutput = null;
            }
            break block10;
            {
                catch (Exception e) {
                    throw new DataImportHandlerException(500, "Unable to persist Index Start Time", e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (propOutput != null) {
                        propOutput.close();
                    }
                }
                catch (IOException e) {
                    propOutput = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties readIndexerProperties() {
        Properties props;
        block11: {
            props = new Properties();
            InputStream propInput = null;
            propInput = new FileInputStream(this.configDir + this.persistFilename);
            props.load(propInput);
            log.info("Read " + this.persistFilename);
            Object var5_3 = null;
            try {
                if (propInput != null) {
                    propInput.close();
                }
                break block11;
            }
            catch (IOException e2) {
                propInput = null;
            }
            break block11;
            {
                catch (Exception e) {
                    log.warn("Unable to read: " + this.persistFilename);
                    Object var5_4 = null;
                    try {
                        if (propInput != null) {
                            propInput.close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {
                        propInput = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (propInput != null) {
                        propInput.close();
                    }
                }
                catch (IOException e2) {
                    propInput = null;
                }
                throw throwable;
            }
        }
        return props;
    }
}

