/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.TemplateString;
import org.apache.solr.handler.dataimport.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableResolverImpl
extends VariableResolver {
    private Map<String, Object> container = new HashMap<String, Object>();
    private final TemplateString templateString = new TemplateString();
    private final Map defaults;
    static final ThreadLocal<VariableResolverImpl> CURRENT_VARIABLE_RESOLVER = new ThreadLocal();
    static final Pattern DOT_SPLIT = Pattern.compile("\\.");

    public VariableResolverImpl() {
        this.defaults = Collections.emptyMap();
    }

    public VariableResolverImpl(Map defaults) {
        this.defaults = defaults;
    }

    public VariableResolverImpl addNamespace(String name, Map<String, Object> map) {
        if (name != null) {
            String[] parts = DOT_SPLIT.split(name, 0);
            Map ns = this.container;
            for (int i = 0; i < parts.length; ++i) {
                if (i == parts.length - 1) {
                    ns.put((String)parts[i], map);
                }
                if (ns.get(parts[i]) == null) {
                    ns.put((String)parts[i], new HashMap());
                    ns = (Map)ns.get(parts[i]);
                    continue;
                }
                if (ns.get(parts[i]) instanceof Map) {
                    ns = (Map)ns.get(parts[i]);
                    continue;
                }
                ns.put(parts[i], new HashMap());
                ns = (Map)ns.get(parts[i]);
            }
        } else {
            this.container.putAll(map);
        }
        return this;
    }

    public void removeNamespace(String name) {
        if (name != null) {
            this.container.remove(name);
        }
    }

    @Override
    public String replaceTokens(String template) {
        return this.templateString.replaceTokens(template, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolve(String name) {
        if (name == null) {
            return this.container;
        }
        if ("".equals(name)) {
            return null;
        }
        String[] parts = DOT_SPLIT.split(name, 0);
        CURRENT_VARIABLE_RESOLVER.set(this);
        try {
            Map namespace = this.container;
            for (int i = 0; i < parts.length; ++i) {
                String thePart = parts[i];
                if (i == parts.length - 1) {
                    Object val = namespace.get(thePart);
                    Object object = val == null ? this.getDefault(name) : val;
                    return object;
                }
                Object temp = namespace.get(thePart);
                if (temp == null) {
                    Object val = namespace.get(this.mergeAll(parts, i));
                    Object object = val == null ? this.getDefault(name) : val;
                    return object;
                }
                if (!(temp instanceof Map)) {
                    Object object = this.getDefault(name);
                    return object;
                }
                namespace = (Map)temp;
            }
        }
        finally {
            CURRENT_VARIABLE_RESOLVER.remove();
        }
        return this.getDefault(name);
    }

    private Object getDefault(String name) {
        Object val = this.defaults.get(name);
        return val == null ? System.getProperty(name) : val;
    }

    private String mergeAll(String[] parts, int i) {
        if (i == parts.length - 1) {
            return parts[parts.length - 1];
        }
        StringBuilder sb = new StringBuilder();
        for (int j = i; j < parts.length; ++j) {
            sb.append(parts[j]);
            if (j >= parts.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

