/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import java.util.List;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.PagingBean;
import org.seasar.robot.dbflute.cbean.PagingHandler;
import org.seasar.robot.dbflute.cbean.PagingResultBean;
import org.seasar.robot.dbflute.cbean.ResultBeanBuilder;
import org.seasar.robot.dbflute.exception.PagingOverSafetySizeException;
import org.seasar.robot.dbflute.exception.PagingStatusInvalidException;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingInvoker<ENTITY> {
    protected final String _tableDbName;

    public PagingInvoker(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagingResultBean<ENTITY> invokePaging(PagingHandler<ENTITY> handler) {
        this.assertObjectNotNull("handler", handler);
        PagingBean pagingBean = handler.getPagingBean();
        this.assertObjectNotNull("handler.getPagingBean()", pagingBean);
        if (!pagingBean.isFetchScopeEffective()) {
            this.throwPagingStatusInvalidException(pagingBean);
        }
        int safetyMaxResultSize = pagingBean.getSafetyMaxResultSize();
        ResultBeanBuilder<ENTITY> builder = this.createResultBeanBuilder();
        try {
            int allRecordCount;
            List<ENTITY> selectedList;
            if (pagingBean.canPagingCountLater()) {
                selectedList = this.executePaging(handler);
                allRecordCount = this.isCurrentLastPage(selectedList, pagingBean) ? this.deriveAllRecordCountByLastPage(selectedList, pagingBean) : this.executeCount(handler);
                this.checkSafetyResultIfNeed(safetyMaxResultSize, allRecordCount);
            } else {
                allRecordCount = this.executeCount(handler);
                this.checkSafetyResultIfNeed(safetyMaxResultSize, allRecordCount);
                selectedList = allRecordCount == 0 ? builder.buildEmptyListResultBean(pagingBean) : this.executePaging(handler);
            }
            PagingResultBean<ENTITY> rb = builder.buildPagingResultBean(pagingBean, allRecordCount, selectedList);
            if (pagingBean.canPagingReSelect() && this.isNecessaryToReadPageAgain(rb)) {
                PagingResultBean<ENTITY> pagingResultBean = this.reselect(handler, pagingBean, builder, rb);
                return pagingResultBean;
            }
            PagingResultBean<ENTITY> pagingResultBean = rb;
            return pagingResultBean;
        }
        finally {
            pagingBean.xsetPaging(true);
        }
    }

    protected ResultBeanBuilder<ENTITY> createResultBeanBuilder() {
        return new ResultBeanBuilder(this._tableDbName);
    }

    protected int executeCount(PagingHandler<ENTITY> handler) {
        return handler.count();
    }

    protected List<ENTITY> executePaging(PagingHandler<ENTITY> handler) {
        return handler.paging();
    }

    protected PagingResultBean<ENTITY> reselect(PagingHandler<ENTITY> handler, PagingBean pagingBean, ResultBeanBuilder<ENTITY> builder, PagingResultBean<ENTITY> rb) {
        pagingBean.fetchPage(rb.getAllPageCount());
        int reAllRecordCount = this.executeCount(handler);
        List<ENTITY> reSelectedList = this.executePaging(handler);
        return builder.buildPagingResultBean(pagingBean, reAllRecordCount, reSelectedList);
    }

    protected boolean isCurrentLastPage(List<ENTITY> selectedList, PagingBean pagingBean) {
        if (selectedList.size() == 0 && pagingBean.getFetchPageNumber() > 1) {
            return false;
        }
        return selectedList.size() <= pagingBean.getFetchSize() - 1;
    }

    protected int deriveAllRecordCountByLastPage(List<ENTITY> selectedList, PagingBean pagingBean) {
        int baseSize = (pagingBean.getFetchPageNumber() - 1) * pagingBean.getFetchSize();
        return baseSize + selectedList.size();
    }

    protected boolean isNecessaryToReadPageAgain(PagingResultBean<ENTITY> rb) {
        return rb.getAllRecordCount() > 0 && rb.getSelectedList().isEmpty();
    }

    protected void checkSafetyResultIfNeed(int safetyMaxResultSize, int allRecordCount) {
        if (safetyMaxResultSize > 0 && allRecordCount > safetyMaxResultSize) {
            this.throwPagingOverSafetySizeException(safetyMaxResultSize, allRecordCount);
        }
    }

    protected void throwPagingOverSafetySizeException(int safetyMaxResultSize, int allRecordCount) {
        String msg = "The paging was over the specified safety size:";
        msg = msg + " " + allRecordCount + " > " + safetyMaxResultSize;
        throw new PagingOverSafetySizeException(msg, safetyMaxResultSize, allRecordCount);
    }

    protected void throwPagingStatusInvalidException(PagingBean pagingBean) {
        boolean cbean = pagingBean instanceof ConditionBean;
        String name = cbean ? "condition-bean" : "parameter-bean";
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The status of paging was INVALID. (paging parameters was not found)");
        br.addItem("Advice");
        br.addElement("Confirm your logic for paging of " + name + ".");
        br.addElement("Paging execution needs paging parameters 'pageSize' and 'pageNumber'.");
        br.addElement("For example:");
        br.addElement("  (x):");
        if (cbean) {
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.query().set...;");
            br.addElement("    ... = memberBhv.selectPage(cb);");
        } else {
            br.addElement("    SimpleMemberPmb pmb = new SimpleMemberPmb();");
            br.addElement("    pmb.set...;");
            br.addElement("    ... = memberBhv.outsideSql().manualPaging().selectPage(...);");
        }
        br.addElement("  (o):");
        if (cbean) {
            br.addElement("    MemberCB cb = new MemberCB();");
            br.addElement("    cb.query().set...;");
            br.addElement("    cb.paging(20, 2); // *Point!");
            br.addElement("    ... = memberBhv.selectPage(cb);");
        } else {
            br.addElement("    SimpleMemberPmb pmb = new SimpleMemberPmb();");
            br.addElement("    pmb.set...;");
            br.addElement("    pmb.paging(20, 2); // *Point!");
            br.addElement("    ... = memberBhv.outsideSql().manualPaging().selectPage(...);");
        }
        br.addItem("PagingBean");
        br.addElement(pagingBean);
        String msg = br.buildExceptionMessage();
        throw new PagingStatusInvalidException(msg);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

