/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.robot.dbflute.twowaysql.SqlAnalyzer;
import org.seasar.robot.dbflute.twowaysql.context.CommandContext;
import org.seasar.robot.dbflute.twowaysql.context.CommandContextCreator;
import org.seasar.robot.dbflute.twowaysql.exception.EmbeddedVariableCommentContainsBindSymbolException;
import org.seasar.robot.dbflute.twowaysql.node.Node;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndType;
import org.seasar.robot.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.robot.dbflute.twowaysql.node.VariableNode;
import org.seasar.robot.dbflute.util.Srl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedVariableNode
extends VariableNode {
    public static final String PREFIX = "$";

    public EmbeddedVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        super(expression, testValue, specifiedSql, blockNullParameter);
    }

    @Override
    protected void doProcess(CommandContext ctx, ValueAndType valueAndType) {
        Object finalValue = valueAndType.getTargetValue();
        Class<?> finalType = valueAndType.getTargetType();
        if (this.isInScope()) {
            if (finalValue == null) {
                this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
            }
            if (List.class.isAssignableFrom(finalType)) {
                this.embedArray(ctx, ((List)finalValue).toArray());
            } else if (finalType.isArray()) {
                this.embedArray(ctx, finalValue);
            } else {
                this.throwBindOrEmbeddedCommentInScopeNotListException(valueAndType);
            }
        } else {
            Class<?> firstType;
            if (finalValue == null) {
                ctx.addSql("null");
                return;
            }
            if (!(finalValue instanceof String)) {
                String embeddedValue = finalValue.toString();
                if (this.isQuotedScalar()) {
                    ctx.addSql(this.quote(embeddedValue));
                } else {
                    ctx.addSql(embeddedValue);
                }
                return;
            }
            String embeddedString = (String)finalValue;
            this.assertNotContainBindSymbol(embeddedString);
            if (this.isQuotedScalar()) {
                ctx.addSql(this.quote(embeddedString));
                if (this.isAcceptableLike()) {
                    this.setupRearOption(ctx, valueAndType);
                }
                return;
            }
            Object firstValue = valueAndType.getFirstValue();
            if (this.processDynamicBinding(ctx, firstValue, firstType = valueAndType.getFirstType(), embeddedString)) {
                return;
            }
            ctx.addSql(embeddedString);
        }
    }

    protected void embedArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        boolean quotedInScope = this.isQuotedInScope();
        ctx.addSql("(");
        int validCount = 0;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (validCount > 0) {
                ctx.addSql(", ");
            }
            String currentStr = currentElement.toString();
            this.assertNotContainBindSymbol(currentStr);
            if (quotedInScope) {
                ctx.addSql(this.quote(currentStr));
            } else {
                ctx.addSql(currentStr);
            }
            ++validCount;
        }
        if (validCount == 0) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        ctx.addSql(")");
    }

    protected void assertNotContainBindSymbol(String value) {
        if (this.containsBindSymbol(value)) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The value of embedded comment contained bind symbols.");
            br.addItem("Advice");
            br.addElement("The value of embedded comment should not contain bind symbols.");
            br.addElement("For example, a question mark '?'.");
            br.addItem("Comment Expression");
            br.addElement(this._expression);
            br.addItem("Embedded Value");
            br.addElement(value);
            String msg = br.buildExceptionMessage();
            throw new EmbeddedVariableCommentContainsBindSymbolException(msg);
        }
    }

    protected boolean containsBindSymbol(String value) {
        return value.indexOf("?") > -1;
    }

    protected String quote(String value) {
        return "'" + value + "'";
    }

    protected boolean isQuotedScalar() {
        if (this._testValue == null) {
            return false;
        }
        return Srl.count(this._testValue, "'") > 1 && this._testValue.startsWith("'") && this._testValue.endsWith("'");
    }

    protected boolean isQuotedInScope() {
        if (!this.isInScope()) {
            return false;
        }
        return Srl.count(this._testValue, "'") > 1;
    }

    protected boolean processDynamicBinding(CommandContext ctx, Object firstValue, Class<?> firstType, String embeddedString) {
        Srl.ScopeInfo first = Srl.extractScopeFirst(embeddedString, "/*", "*/");
        if (first == null) {
            return false;
        }
        SqlAnalyzer analyzer = new SqlAnalyzer(embeddedString, this._blockNullParameter);
        Node rootNode = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(new String[]{"pmb"}, new Class[]{firstType});
        CommandContext rootCtx = creator.createCommandContext(new Object[]{firstValue});
        rootNode.accept(rootCtx);
        String sql = rootCtx.getSql();
        ctx.addSql(sql, rootCtx.getBindVariables(), rootCtx.getBindVariableTypes());
        return true;
    }

    @Override
    protected ValueAndTypeSetupper.CommentType getCommentType() {
        return ValueAndTypeSetupper.CommentType.EMBEDDED;
    }
}

