/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.PathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathParser
implements Expression {
    private LinkedList<Integer> indexes = new LinkedList();
    private LinkedList<String> names = new LinkedList();
    private String cache;
    private String path;
    private Class type;
    private boolean attribute;
    private char[] data;
    private int count;
    private int start;
    private int off;

    public PathParser(Class type, String path) throws Exception {
        this.type = type;
        this.path = path;
        this.parse(path);
    }

    @Override
    public boolean isPath() {
        return this.names.size() > 1;
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public int getIndex() {
        return this.indexes.getFirst();
    }

    @Override
    public String getFirst() {
        return this.names.getFirst();
    }

    @Override
    public String getLast() {
        return this.names.getLast();
    }

    @Override
    public Iterator<String> iterator() {
        return this.names.iterator();
    }

    @Override
    public Expression getPath(int from) {
        return this.getPath(from, 0);
    }

    @Override
    public Expression getPath(int from, int trim) {
        int last = this.names.size() - 1;
        if (last - trim >= from) {
            return new PathSection(from, last - trim);
        }
        return new PathSection(from, from);
    }

    private void parse(String path) throws Exception {
        if (path != null) {
            this.count = path.length();
            this.data = new char[this.count];
            path.getChars(0, this.count, this.data, 0);
        }
        this.path();
    }

    private void path() throws Exception {
        if (this.data[this.off] == '/') {
            throw new PathException("Path '%s' in %s references document root", this.path, this.type);
        }
        if (this.data[this.off] == '.') {
            this.skip();
        }
        while (this.off < this.count) {
            this.segment();
        }
        this.truncate();
    }

    private void skip() throws Exception {
        if (this.data.length > 1) {
            if (this.data[this.off + 1] != '/') {
                throw new PathException("Path '%s' in %s has an illegal syntax", this.path, this.type);
            }
            ++this.off;
        }
        this.start = ++this.off;
    }

    private void segment() throws Exception {
        char first = this.data[this.off];
        if (first == '/') {
            throw new PathException("Invalid path expression '%s' in %s", this.path, this.type);
        }
        if (first == '@') {
            this.attribute();
        } else {
            this.element();
        }
        this.align();
    }

    private void element() throws Exception {
        int mark = this.off;
        int size = 0;
        while (this.off < this.count) {
            char value;
            if (!this.isValid(value = this.data[this.off++])) {
                if (value == '[') {
                    this.index();
                    break;
                }
                if (value == '/') break;
                throw new PathException("Illegal character '%s' in element for '%s' in %s", Character.valueOf(value), this.path, this.type);
            }
            ++size;
        }
        this.append(mark, size);
    }

    private void attribute() throws Exception {
        int mark = ++this.off;
        while (this.off < this.count) {
            char value;
            if (this.isValid(value = this.data[this.off++])) continue;
            throw new PathException("Illegal character '%s' in attribute for '%s' in %s", Character.valueOf(value), this.path, this.type);
        }
        if (this.off <= mark) {
            throw new PathException("Attribute reference in '%s' for %s is empty", this.path, this.type);
        }
        this.attribute = true;
        this.append(mark, this.off - mark);
    }

    private void index() throws Exception {
        int value = 0;
        if (this.data[this.off - 1] == '[') {
            char digit;
            while (this.off < this.count && this.isDigit(digit = this.data[this.off++])) {
                value *= 10;
                value += digit;
                value -= 48;
            }
        }
        if (this.data[this.off++ - 1] != ']') {
            throw new PathException("Invalid index for path '%s' in %s", this.path, this.type);
        }
        this.indexes.add(value);
    }

    private void truncate() throws Exception {
        if (this.off - 1 >= this.data.length) {
            --this.off;
        } else if (this.data[this.off - 1] == '/') {
            --this.off;
        }
    }

    private void align() throws Exception {
        int size;
        int require = this.names.size();
        if (require > (size = this.indexes.size())) {
            this.indexes.add(1);
        }
    }

    private boolean isDigit(char value) {
        return Character.isDigit(value);
    }

    private boolean isValid(char value) {
        return this.isLetter(value) || this.isSpecial(value);
    }

    private boolean isSpecial(char value) {
        return value == '_' || value == '-' || value == ':';
    }

    private boolean isLetter(char value) {
        return Character.isLetterOrDigit(value);
    }

    private void append(int start, int count) {
        String segment = new String(this.data, start, count);
        if (count > 0) {
            this.names.add(segment);
        }
    }

    @Override
    public String toString() {
        int size = this.off - this.start;
        if (this.cache == null) {
            this.cache = new String(this.data, this.start, size);
        }
        return this.cache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSection
    implements Expression {
        private List<String> cache = new ArrayList<String>();
        private String path;
        private int begin;
        private int end;

        public PathSection(int index, int end) {
            this.begin = index;
            this.end = end;
        }

        @Override
        public boolean isPath() {
            return this.end - this.begin >= 1;
        }

        @Override
        public boolean isAttribute() {
            return this.end >= PathParser.this.names.size() - 1;
        }

        @Override
        public int getIndex() {
            return (Integer)PathParser.this.indexes.get(this.begin);
        }

        @Override
        public String getFirst() {
            return (String)PathParser.this.names.get(this.begin);
        }

        @Override
        public String getLast() {
            return (String)PathParser.this.names.get(this.end);
        }

        @Override
        public Expression getPath(int from) {
            return this.getPath(from, 0);
        }

        @Override
        public Expression getPath(int from, int trim) {
            return new PathSection(this.begin + from, this.end - trim);
        }

        @Override
        public Iterator<String> iterator() {
            if (this.cache.isEmpty()) {
                for (int i = this.begin; i <= this.end; ++i) {
                    String segment = (String)PathParser.this.names.get(i);
                    if (segment == null) continue;
                    this.cache.add(segment);
                }
            }
            return this.cache.iterator();
        }

        private String getPath() {
            int last = PathParser.this.start;
            int pos = 0;
            int i = 0;
            while (i <= this.end) {
                if (last >= PathParser.this.count) {
                    ++last;
                    break;
                }
                if (PathParser.this.data[last++] != '/' || ++i != this.begin) continue;
                pos = last;
            }
            return new String(PathParser.this.data, pos, --last - pos);
        }

        @Override
        public String toString() {
            if (this.path == null) {
                this.path = this.getPath();
            }
            return this.path;
        }
    }
}

