/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.Comparer;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.ExpressionBuilder;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelFactory;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Model;
import org.simpleframework.xml.core.ModelAssembler;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Structure;
import org.simpleframework.xml.core.TextException;
import org.simpleframework.xml.core.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructureBuilder {
    private ExpressionBuilder builder;
    private ModelAssembler assembler;
    private LabelMap attributes;
    private LabelMap elements;
    private Comparer comparer;
    private Scanner scanner;
    private Label version;
    private Label text;
    private Model root;
    private Class type;
    private boolean primitive;

    public StructureBuilder(Scanner scanner, Class type) throws Exception {
        this.builder = new ExpressionBuilder(type);
        this.assembler = new ModelAssembler(this.builder);
        this.attributes = new LabelMap(scanner);
        this.elements = new LabelMap(scanner);
        this.root = new TreeModel(scanner);
        this.comparer = new Comparer();
        this.scanner = scanner;
        this.type = type;
    }

    public void assemble(Class type) throws Exception {
        Order order = this.scanner.getOrder();
        if (order != null) {
            this.assembler.assemble(this.root, order);
        }
    }

    public void process(Contact field, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Version) {
            this.version(field, label);
        }
        if (label instanceof Text) {
            this.text(field, label);
        }
    }

    private void process(Contact field, Annotation type, LabelMap map) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        String name = label.getName();
        if (map.get(name) != null) {
            throw new PersistenceException("Annotation of name '%s' declared twice", name);
        }
        this.process(field, label, map);
        this.validate(label, name);
    }

    private void process(Contact field, Label label, LabelMap map) throws Exception {
        String name = label.getName();
        String path = label.getPath();
        Model model = this.root;
        if (path != null) {
            model = this.register(path);
        }
        model.register(label);
        map.put(name, label);
    }

    private void text(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.text != null) {
            throw new TextException("Multiple text annotations in %s", type);
        }
        this.text = label;
    }

    private void version(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", type);
        }
        this.version = label;
    }

    public Structure build(Class type) {
        return new Structure(this.root, this.version, this.text, this.primitive);
    }

    private boolean isElement(String path) throws Exception {
        Expression target = this.builder.build(path);
        Model model = this.lookup(target);
        if (model != null) {
            String name = target.getLast();
            if (model.isElement(name)) {
                return true;
            }
            return model.isModel(name);
        }
        return false;
    }

    private boolean isAttribute(String path) throws Exception {
        Expression target = this.builder.build(path);
        Model model = this.lookup(target);
        if (model != null) {
            String name = target.getLast();
            return model.isAttribute(name);
        }
        return false;
    }

    private Model lookup(Expression path) throws Exception {
        Expression target = path.getPath(0, 1);
        if (path.isPath()) {
            return this.root.lookup(target);
        }
        return this.root;
    }

    private Model register(String path) throws Exception {
        Expression expression = this.builder.build(path);
        Model model = this.root.lookup(expression);
        if (model != null) {
            return model;
        }
        return this.create(expression);
    }

    private Model create(Expression path) throws Exception {
        Model model = this.root;
        while (model != null) {
            String name = path.getFirst();
            int index = path.getIndex();
            if (name != null) {
                model = model.register(name, index);
            }
            if (!path.isPath()) break;
            path = path.getPath(1);
        }
        return model;
    }

    public void validate(Class type) throws Exception {
        Creator creator = this.scanner.getCreator();
        Order order = this.scanner.getOrder();
        this.validateElements(type, order);
        this.validateAttributes(type, order);
        this.validateParameters(creator);
        this.validateConstructors(type);
        this.validateModel(type);
        this.validateText(type);
    }

    private void validateModel(Class type) throws Exception {
        if (!this.root.isEmpty()) {
            this.root.validate(type);
        }
    }

    private void validateText(Class type) throws Exception {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, type);
            }
            if (this.root.isComposite()) {
                throw new TextException("Paths used with %s in %s", this.text, type);
            }
        } else if (this.scanner.isEmpty()) {
            this.primitive = this.isEmpty();
        }
    }

    private void validateElements(Class type, Order order) throws Exception {
        if (order != null) {
            for (String name : order.elements()) {
                if (this.isElement(name)) continue;
                throw new ElementException("Ordered element '%s' missing for %s", name, type);
            }
        }
    }

    private void validateAttributes(Class type, Order order) throws Exception {
        if (order != null) {
            for (String name : order.attributes()) {
                if (this.isAttribute(name)) continue;
                throw new AttributeException("Ordered attribute '%s' missing for %s", name, type);
            }
        }
    }

    private void validateConstructors(Class type) throws Exception {
        Creator creator = this.scanner.getCreator();
        List<Builder> builders = creator.getBuilders();
        if (creator.isDefault()) {
            this.validateConstructors(this.elements);
            this.validateConstructors(this.attributes);
        }
        if (!builders.isEmpty()) {
            this.validateConstructors(this.elements, builders);
            this.validateConstructors(this.attributes, builders);
        }
    }

    private void validateConstructors(LabelMap map) throws Exception {
        for (Label label : map) {
            Contact contact;
            if (label == null || !(contact = label.getContact()).isReadOnly()) continue;
            throw new ConstructorException("Default constructor can not accept read only %s in %s", label, this.type);
        }
    }

    private void validateConstructors(LabelMap map, List<Builder> builders) throws Exception {
        for (Label label : map) {
            if (label == null) continue;
            this.validateConstructor(label, builders);
        }
        if (builders.isEmpty()) {
            throw new ConstructorException("No constructor accepts all read only values in %s", this.type);
        }
    }

    private void validateConstructor(Label label, List<Builder> builders) throws Exception {
        Iterator<Builder> list = builders.iterator();
        while (list.hasNext()) {
            Parameter value;
            Builder builder = list.next();
            Contact contact = label.getContact();
            String name = label.getName();
            if (!contact.isReadOnly() || (value = builder.getParameter(name)) != null) continue;
            list.remove();
        }
    }

    private void validateParameters(Creator creator) throws Exception {
        List<Parameter> list = creator.getParameters();
        for (Parameter parameter : list) {
            String name = parameter.getName();
            Label label = (Label)this.elements.get(name);
            if (this.isEmpty(name)) {
                label = this.text;
            }
            if (label == null) {
                label = (Label)this.attributes.get(name);
            }
            if (label != null) continue;
            throw new ConstructorException("Parameter '%s' does not have a match in %s", name, this.type);
        }
    }

    private void validate(Label field, String name) throws Exception {
        Creator factory = this.scanner.getCreator();
        Parameter parameter = factory.getParameter(name);
        if (parameter != null) {
            this.validate(field, parameter);
        }
    }

    private void validate(Label field, Parameter parameter) throws Exception {
        Contact contact = field.getContact();
        Annotation label = contact.getAnnotation();
        Annotation match = parameter.getAnnotation();
        String name = field.getName();
        if (!this.comparer.equals(label, match)) {
            throw new ConstructorException("Annotation does not match for '%s' in %s", name, this.type);
        }
        Class expect = contact.getType();
        if (expect != parameter.getType()) {
            throw new ConstructorException("Parameter does not match field for '%s' in %s", name, this.type);
        }
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }

    private boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        return this.root.isEmpty();
    }
}

