/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SubSampleInformationBox
extends AbstractFullBox {
    public static final String TYPE = "subs";
    private long entryCount;
    private List<SampleEntry> sampleEntries = new ArrayList<SampleEntry>();

    public SubSampleInformationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        long entries = 4L + 6L * this.entryCount;
        int subsampleEntries = 0;
        for (SampleEntry sampleEntry : this.sampleEntries) {
            subsampleEntries += sampleEntry.getSubsampleCount() * ((this.getVersion() == 1 ? 4 : 2) + 1 + 1 + 4);
        }
        return entries + (long)subsampleEntries;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.entryCount = in.readUInt32();
        int i = 0;
        while ((long)i < this.entryCount) {
            SampleEntry sampleEntry = new SampleEntry();
            sampleEntry.setSampleDelta(in.readUInt32());
            int subsampleCount = in.readUInt16();
            sampleEntry.setSubsampleCount(subsampleCount);
            for (int j = 0; j < subsampleCount; ++j) {
                SampleEntry.SubsampleEntry subsampleEntry = new SampleEntry.SubsampleEntry();
                subsampleEntry.setSubsampleSize(this.getVersion() == 1 ? in.readUInt32() : (long)in.readUInt16());
                subsampleEntry.setSubsamplePriority(in.readUInt8());
                subsampleEntry.setDiscardable(in.readUInt8());
                subsampleEntry.setReserved(in.readUInt32());
                sampleEntry.addSubsampleEntry(subsampleEntry);
            }
            this.sampleEntries.add(sampleEntry);
            ++i;
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.entryCount);
        for (SampleEntry sampleEntry : this.sampleEntries) {
            os.writeUInt32(sampleEntry.getSampleDelta());
            List<SampleEntry.SubsampleEntry> subsampleEntries = sampleEntry.getSubsampleEntries();
            for (SampleEntry.SubsampleEntry subsampleEntry : subsampleEntries) {
                if (this.getVersion() == 1) {
                    os.writeUInt32(subsampleEntry.getSubsampleSize());
                } else {
                    os.writeUInt16((int)subsampleEntry.getSubsampleSize());
                }
                os.writeUInt8(subsampleEntry.getSubsamplePriority());
                os.writeUInt8(subsampleEntry.getDiscardable());
                os.writeUInt32(subsampleEntry.getReserved());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleEntry {
        private long sampleDelta;
        private int subsampleCount;
        private List<SubsampleEntry> subsampleEntries = new ArrayList<SubsampleEntry>();

        public long getSampleDelta() {
            return this.sampleDelta;
        }

        public void setSampleDelta(long sampleDelta) {
            this.sampleDelta = sampleDelta;
        }

        public int getSubsampleCount() {
            return this.subsampleCount;
        }

        public void setSubsampleCount(int subsampleCount) {
            this.subsampleCount = subsampleCount;
        }

        public List<SubsampleEntry> getSubsampleEntries() {
            return this.subsampleEntries;
        }

        public void addSubsampleEntry(SubsampleEntry subsampleEntry) {
            this.subsampleEntries.add(subsampleEntry);
        }

        public static class SubsampleEntry {
            private long subsampleSize;
            private int subsamplePriority;
            private int discardable;
            private long reserved;

            public long getSubsampleSize() {
                return this.subsampleSize;
            }

            public void setSubsampleSize(long subsampleSize) {
                this.subsampleSize = subsampleSize;
            }

            public int getSubsamplePriority() {
                return this.subsamplePriority;
            }

            public void setSubsamplePriority(int subsamplePriority) {
                this.subsamplePriority = subsamplePriority;
            }

            public int getDiscardable() {
                return this.discardable;
            }

            public void setDiscardable(int discardable) {
                this.discardable = discardable;
            }

            public long getReserved() {
                return this.reserved;
            }

            public void setReserved(long reserved) {
                this.reserved = reserved;
            }
        }
    }
}

