/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.sampleentry;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.sampleentry.SampleEntry;
import java.io.IOException;

public class TextSampleEntry
extends SampleEntry {
    public static final String TYPE1 = "tx3g";
    public static final String TYPE_ENCRYPTED = "enct";
    private long displayFlags;
    private int horizontalJustification;
    private int verticalJustification;
    private int[] backgroundColorRgba = new int[4];
    private BoxRecord boxRecord = new BoxRecord();
    private StyleRecord styleRecord = new StyleRecord();

    public TextSampleEntry(byte[] type) {
        super(type);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.displayFlags = in.readUInt32();
        this.horizontalJustification = in.readUInt8();
        this.verticalJustification = in.readUInt8();
        this.backgroundColorRgba = new int[4];
        this.backgroundColorRgba[0] = in.readUInt8();
        this.backgroundColorRgba[1] = in.readUInt8();
        this.backgroundColorRgba[2] = in.readUInt8();
        this.backgroundColorRgba[3] = in.readUInt8();
        size -= 18L;
        this.boxRecord = new BoxRecord();
        this.boxRecord.parse(in);
        size -= (long)this.boxRecord.getSize();
        this.styleRecord = new StyleRecord();
        this.styleRecord.parse(in);
        size -= (long)this.styleRecord.getSize();
        while (size > 0L) {
            Box b = boxParser.parseBox(in, this, lastMovieFragmentBox);
            this.boxes.add(b);
            size -= b.getSize();
        }
    }

    protected long getContentSize() {
        long contentSize = 18L;
        contentSize += (long)this.boxRecord.getSize();
        contentSize += (long)this.styleRecord.getSize();
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public String toString() {
        return "TextSampleEntry";
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(new byte[6]);
        isos.writeUInt16(this.getDataReferenceIndex());
        isos.writeUInt32(this.displayFlags);
        isos.writeUInt8(this.horizontalJustification);
        isos.writeUInt8(this.verticalJustification);
        isos.writeUInt8(this.backgroundColorRgba[0]);
        isos.writeUInt8(this.backgroundColorRgba[1]);
        isos.writeUInt8(this.backgroundColorRgba[2]);
        isos.writeUInt8(this.backgroundColorRgba[3]);
        this.boxRecord.getContent(isos);
        this.styleRecord.getContent(isos);
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }

    public BoxRecord getBoxRecord() {
        return this.boxRecord;
    }

    public void setBoxRecord(BoxRecord boxRecord) {
        this.boxRecord = boxRecord;
    }

    public StyleRecord getStyleRecord() {
        return this.styleRecord;
    }

    public void setStyleRecord(StyleRecord styleRecord) {
        this.styleRecord = styleRecord;
    }

    public boolean isScrollIn() {
        return (this.displayFlags & 0x20L) == 32L;
    }

    public void setScrollIn(boolean scrollIn) {
        this.displayFlags = scrollIn ? (this.displayFlags |= 0x20L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean isScrollOut() {
        return (this.displayFlags & 0x40L) == 64L;
    }

    public void setScrollOut(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x40L) : (this.displayFlags &= 0xFFFFFFFFFFFFFFBFL);
    }

    public boolean isScrollDirection() {
        return (this.displayFlags & 0x180L) == 384L;
    }

    public void setScrollDirection(boolean scrollOutIn) {
        this.displayFlags = scrollOutIn ? (this.displayFlags |= 0x180L) : (this.displayFlags &= 0xFFFFFFFFFFFFFE7FL);
    }

    public boolean isContinuousKaraoke() {
        return (this.displayFlags & 0x800L) == 2048L;
    }

    public void setContinuousKaraoke(boolean continuousKaraoke) {
        this.displayFlags = continuousKaraoke ? (this.displayFlags |= 0x800L) : (this.displayFlags &= 0xFFFFFFFFFFFFF7FFL);
    }

    public boolean isWriteTextVertically() {
        return (this.displayFlags & 0x20000L) == 131072L;
    }

    public void setWriteTextVertically(boolean writeTextVertically) {
        this.displayFlags = writeTextVertically ? (this.displayFlags |= 0x20000L) : (this.displayFlags &= 0xFFFFFFFFFFFDFFFFL);
    }

    public boolean isFillTextRegion() {
        return (this.displayFlags & 0x40000L) == 262144L;
    }

    public void setFillTextRegion(boolean fillTextRegion) {
        this.displayFlags = fillTextRegion ? (this.displayFlags |= 0x40000L) : (this.displayFlags &= 0xFFFFFFFFFFFBFFFFL);
    }

    public int getHorizontalJustification() {
        return this.horizontalJustification;
    }

    public void setHorizontalJustification(int horizontalJustification) {
        this.horizontalJustification = horizontalJustification;
    }

    public int getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setVerticalJustification(int verticalJustification) {
        this.verticalJustification = verticalJustification;
    }

    public int[] getBackgroundColorRgba() {
        return this.backgroundColorRgba;
    }

    public void setBackgroundColorRgba(int[] backgroundColorRgba) {
        this.backgroundColorRgba = backgroundColorRgba;
    }

    public static class StyleRecord {
        int startChar;
        int endChar;
        int fontId;
        int faceStyleFlags;
        int fontSize;
        int[] textColor = new int[]{255, 255, 255, 255};

        public void parse(IsoBufferWrapper in) throws IOException {
            this.startChar = in.readUInt16();
            this.endChar = in.readUInt16();
            this.fontId = in.readUInt16();
            this.faceStyleFlags = in.readUInt8();
            this.fontSize = in.readUInt8();
            this.textColor = new int[4];
            this.textColor[0] = in.readUInt8();
            this.textColor[1] = in.readUInt8();
            this.textColor[2] = in.readUInt8();
            this.textColor[3] = in.readUInt8();
        }

        public void getContent(IsoOutputStream isos) throws IOException {
            isos.writeUInt16(this.startChar);
            isos.writeUInt16(this.endChar);
            isos.writeUInt16(this.fontId);
            isos.writeUInt8(this.faceStyleFlags);
            isos.writeUInt8(this.fontSize);
            isos.writeUInt8(this.textColor[0]);
            isos.writeUInt8(this.textColor[1]);
            isos.writeUInt8(this.textColor[2]);
            isos.writeUInt8(this.textColor[3]);
        }

        public int getSize() {
            return 12;
        }
    }

    public static class BoxRecord {
        int top;
        int left;
        int bottom;
        int right;

        public void parse(IsoBufferWrapper in) throws IOException {
            this.top = in.readUInt16();
            this.left = in.readUInt16();
            this.bottom = in.readUInt16();
            this.right = in.readUInt16();
        }

        public void getContent(IsoOutputStream isos) throws IOException {
            isos.writeUInt16(this.top);
            isos.writeUInt16(this.left);
            isos.writeUInt16(this.bottom);
            isos.writeUInt16(this.right);
        }

        public int getSize() {
            return 8;
        }
    }
}

