/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendTrack
extends AbstractTrack {
    Track[] tracks;

    public AppendTrack(Track ... tracks) throws IOException {
        this.tracks = tracks;
        byte[] referenceSampleDescriptionBox = null;
        for (Track track : tracks) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            track.getSampleDescriptionBox().getBox(new IsoOutputStream(baos));
            if (referenceSampleDescriptionBox == null) {
                referenceSampleDescriptionBox = baos.toByteArray();
                continue;
            }
            if (Arrays.equals(referenceSampleDescriptionBox, baos.toByteArray())) continue;
            throw new IOException("Cannot append " + track + " to " + tracks[0] + " since their Sample Description Boxes differ");
        }
    }

    @Override
    public List<IsoBufferWrapper> getSamples() {
        ArrayList<IsoBufferWrapper> lists = new ArrayList<IsoBufferWrapper>();
        for (Track track : this.tracks) {
            lists.addAll(track.getSamples());
        }
        return lists;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        return this.tracks[0].getSampleDescriptionBox();
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        if (this.tracks[0].getDecodingTimeEntries() != null && !this.tracks[0].getDecodingTimeEntries().isEmpty()) {
            LinkedList<long[]> lists = new LinkedList<long[]>();
            for (Track track : this.tracks) {
                lists.add(TimeToSampleBox.blowupTimeToSamples(track.getDecodingTimeEntries()));
            }
            LinkedList<TimeToSampleBox.Entry> returnDecodingEntries = new LinkedList<TimeToSampleBox.Entry>();
            Iterator i$ = lists.iterator();
            while (i$.hasNext()) {
                long[] list;
                for (long nuDecodingTime : list = (long[])i$.next()) {
                    TimeToSampleBox.Entry e;
                    if (returnDecodingEntries.isEmpty() || returnDecodingEntries.getLast().getDelta() != nuDecodingTime) {
                        e = new TimeToSampleBox.Entry(1L, nuDecodingTime);
                        returnDecodingEntries.add(e);
                        continue;
                    }
                    e = returnDecodingEntries.getLast();
                    e.setCount(e.getCount() + 1L);
                }
            }
            return returnDecodingEntries;
        }
        return null;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        if (this.tracks[0].getCompositionTimeEntries() != null && !this.tracks[0].getCompositionTimeEntries().isEmpty()) {
            LinkedList<int[]> lists = new LinkedList<int[]>();
            for (Track track : this.tracks) {
                lists.add(CompositionTimeToSample.blowupCompositionTimes(track.getCompositionTimeEntries()));
            }
            LinkedList<CompositionTimeToSample.Entry> compositionTimeEntries = new LinkedList<CompositionTimeToSample.Entry>();
            Iterator i$ = lists.iterator();
            while (i$.hasNext()) {
                int[] list;
                for (int compositionTime : list = (int[])i$.next()) {
                    CompositionTimeToSample.Entry e;
                    if (compositionTimeEntries.isEmpty() || compositionTimeEntries.getLast().getOffset() != compositionTime) {
                        e = new CompositionTimeToSample.Entry(1L, compositionTime);
                        compositionTimeEntries.add(e);
                        continue;
                    }
                    e = compositionTimeEntries.getLast();
                    e.setCount(e.getCount() + 1L);
                }
            }
            return compositionTimeEntries;
        }
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.tracks[0].getSyncSamples() != null && this.tracks[0].getSyncSamples().length > 0) {
            int numSyncSamples = 0;
            for (Track track : this.tracks) {
                numSyncSamples += track.getSyncSamples().length;
            }
            long[] returnSyncSamples = new long[numSyncSamples];
            int pos = 0;
            for (Track track : this.tracks) {
                for (long l : track.getSyncSamples()) {
                    returnSyncSamples[pos++] = l;
                }
            }
            return returnSyncSamples;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.tracks[0].getSampleDependencies() != null && !this.tracks[0].getSampleDependencies().isEmpty()) {
            LinkedList<SampleDependencyTypeBox.Entry> list = new LinkedList<SampleDependencyTypeBox.Entry>();
            for (Track track : this.tracks) {
                list.addAll(track.getSampleDependencies());
            }
            return list;
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.tracks[0].getTrackMetaData();
    }

    @Override
    public Track.Type getType() {
        return this.tracks[0].getType();
    }
}

