/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.seasar.chronos.core.SchedulerConfiguration;
import org.seasar.chronos.core.SchedulerEventListener;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.event.SchedulerEventHandler;
import org.seasar.chronos.core.exception.CancellationRuntimeException;
import org.seasar.chronos.core.exception.ExecutionRuntimeException;
import org.seasar.chronos.core.exception.InterruptedRuntimeException;
import org.seasar.chronos.core.executor.ExecutorServiceFactory;
import org.seasar.chronos.core.handler.ScheduleExecuteHandler;
import org.seasar.chronos.core.impl.AbstractScheduler;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.chronos.core.schedule.TaskScheduleEntryManager;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerImpl
extends AbstractScheduler {
    public static final int SHUTDOWN_AWAIT_TIME = 10;
    public static final TimeUnit SHUTDOWN_AWAIT_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final SchedulerConfiguration defaultConfiguration = new SchedulerConfiguration();
    private final SchedulerEventHandler schedulerEventHandler = new SchedulerEventHandler();
    private final AtomicBoolean pause = new AtomicBoolean();
    private ExecutorService executorService;
    private Future<Void> schedulerTaskFuture;
    private final TaskScheduleEntryManager taskScheduleEntryManager = TaskScheduleEntryManager.getInstance();
    private SchedulerConfiguration configuration = defaultConfiguration;
    private final List<ScheduleExecuteHandler> scheduleExecuteHandlerList = CollectionsUtil.newArrayList();
    private ExecutorServiceFactory executorServiceFactory;
    private long finishStartTime = 0L;
    private boolean initialized;

    public SchedulerImpl() {
        this.schedulerEventHandler.setScheduler(this);
    }

    public void addScheduleExecuteHandler(ScheduleExecuteHandler scheduleExecuteHandler) {
        this.scheduleExecuteHandlerList.add(scheduleExecuteHandler);
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.executorService = this.executorServiceFactory.create(this.configuration.getThreadPoolType(), this.configuration.getThreadPoolSize(), this.configuration.isDaemon());
        this.schedulerEventHandler.setExecutorServiceFacotry(this.executorServiceFactory);
        this.initialized = true;
    }

    @Override
    public boolean addListener(SchedulerEventListener listener) {
        return this.schedulerEventHandler.add(listener);
    }

    @Override
    public synchronized boolean addTask(Class<?> taskComponentClass) {
        S2Container rootS2Container = this.s2container.getRoot();
        boolean result = false;
        result = this.registerChildTaskComponentByTarget(rootS2Container, taskComponentClass);
        result = result || this.registerTaskFromS2ContainerOnSmartDeployByTarget(rootS2Container, taskComponentClass);
        return result;
    }

    @Override
    public SchedulerConfiguration getSchedulerConfiguration() {
        return this.configuration;
    }

    private boolean getSchedulerFinish() {
        if (this.finishStartTime != 0L && this.taskScheduleEntryManager.size(TaskStateType.SCHEDULED) > 0) {
            this.finishStartTime = 0L;
            return false;
        }
        if (this.finishStartTime != 0L && System.currentTimeMillis() - this.finishStartTime >= this.configuration.getAutoFinishTimeLimit()) {
            this.finishStartTime = 0L;
            return true;
        }
        if (this.schedulerTaskFuture != null && this.taskScheduleEntryManager.size(TaskStateType.SCHEDULED) == 0 && this.taskScheduleEntryManager.size(TaskStateType.RUNNING) == 0 && this.configuration.isAutoFinish() && this.finishStartTime == 0L) {
            this.finishStartTime = System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public boolean isPaused() {
        return this.pause.get();
    }

    @Override
    public void join() {
        if (this.configuration.isDaemon()) {
            return;
        }
        log.log("DCHRONOS0016", null);
        try {
            this.schedulerTaskFuture.get();
        }
        catch (CancellationException e) {
            throw new CancellationRuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new InterruptedRuntimeException(e);
            }
            throw new ExecutionRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException(e);
        }
        finally {
            if (!this.schedulerTaskFuture.isCancelled()) {
                this.schedulerEventHandler.fireEndScheduler();
            }
        }
        log.log("DCHRONOS0017", null);
    }

    @Override
    public synchronized void pause() {
        if (!this.pause.get()) {
            log.log("DCHRONOS0018", null);
        } else {
            log.log("DCHRONOS0021", null);
        }
        this.pause.set(!this.pause.get());
        this.notify();
    }

    @Override
    protected void registerTaskFromS2Container() {
        S2Container target = this.s2container.getRoot();
        this.registerTaskFromS2ContainerOnSmartDeploy(target);
        this.registerChildTaskComponent(target);
        this.registerJavascriptTaskComponent();
    }

    @Override
    public boolean removeListener(SchedulerEventListener listener) {
        return this.schedulerEventHandler.remove(listener);
    }

    @Override
    public synchronized boolean removeTask(Class<?> taskClass) {
        TaskScheduleEntry taskScheduleEntry = this.taskScheduleEntryManager.getTaskScheduleEntry(taskClass);
        return this.taskScheduleEntryManager.removeTaskScheduleEntry(taskScheduleEntry);
    }

    protected TaskScheduleEntry unscheduleTask(final ComponentDef componentDef) {
        TaskScheduleEntry target = (TaskScheduleEntry)this.taskScheduleEntryManager.forEach(new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(TaskScheduleEntry scheduleEntry) {
                if (componentDef.equals(scheduleEntry.getComponentDef())) {
                    return scheduleEntry;
                }
                return null;
            }
        });
        if (this.taskScheduleEntryManager.removeTaskScheduleEntry(target)) {
            return target;
        }
        return null;
    }

    @Override
    protected TaskScheduleEntry scheduleTask(ComponentDef taskComponentDef) {
        return this.scheduleTask(taskComponentDef, false);
    }

    @Override
    protected TaskScheduleEntry scheduleTask(ComponentDef taskComponentDef, boolean force) {
        boolean contains = this.taskScheduleEntryManager.contains(taskComponentDef.getComponentClass());
        if (contains) {
            return null;
        }
        TaskScheduleEntry taskScheduleEntry = super.scheduleTask(taskComponentDef, force);
        if (taskScheduleEntry == null) {
            return null;
        }
        this.taskScheduleEntryManager.addTaskScheduleEntry(TaskStateType.SCHEDULED, taskScheduleEntry);
        this.schedulerEventHandler.fireAddTaskScheduleEntry(TaskStateType.SCHEDULED, taskScheduleEntry);
        return taskScheduleEntry;
    }

    @Override
    public void setSchedulerConfiguration(SchedulerConfiguration schedulerConfiguration) {
        this.configuration = schedulerConfiguration;
    }

    private void setupHandler() {
        for (ScheduleExecuteHandler seh : this.scheduleExecuteHandlerList) {
            seh.setExecutorService(this.executorService);
            seh.setPause(this.pause);
            seh.setSchedulerEventHandler(this.schedulerEventHandler);
        }
    }

    @Override
    public void shutdown() {
        log.log("DCHRONOS0013", null);
        this.taskScheduleEntryManager.forEach(TaskStateType.RUNNING, new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(TaskScheduleEntry taskScheduleEntry) {
                taskScheduleEntry.getTaskExecutorService().cancel();
                try {
                    while (!taskScheduleEntry.getTaskExecutorService().await(10L, SHUTDOWN_AWAIT_TIMEUNIT)) {
                        String taskName = taskScheduleEntry.getTaskExecutorService().getTaskPropertyReader().getTaskName(null);
                        AbstractScheduler.log.log("DCHRONOS0014", new Object[]{taskName});
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedRuntimeException(e);
                }
                return null;
            }
        });
        this.schedulerTaskFuture.cancel(true);
        this.schedulerEventHandler.fireShutdownScheduler();
        log.log("DCHRONOS0015", null);
        this.executorServiceFactory.shutdown();
    }

    @Override
    public void start() {
        this.initialize();
        log.log("DCHRONOS0011", null);
        this.schedulerEventHandler.fireRegisterTaskBeforeScheduler();
        this.registerTaskFromS2Container();
        this.setupHandler();
        this.schedulerEventHandler.fireRegisterTaskAfterScheduler();
        this.schedulerTaskFuture = this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException {
                do {
                    for (ScheduleExecuteHandler seh : SchedulerImpl.this.scheduleExecuteHandlerList) {
                        seh.handleRequest();
                    }
                    Thread.sleep(SchedulerImpl.this.configuration.getTaskScanIntervalTime());
                } while (!SchedulerImpl.this.getSchedulerFinish());
                return null;
            }
        });
        this.schedulerEventHandler.fireStartScheduler();
        log.log("DCHRONOS0012", null);
    }

    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    @Override
    public void process() {
        this.start();
        this.join();
    }
}

