/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.OutputStreamUtil;
import org.seasar.struts.upload.S2MultipartRequestHandler;
import org.seasar.struts.util.ActionMessagesUtil;

public final class UploadUtil {
    private UploadUtil() {
    }

    public static boolean checkSizeLimit(HttpServletRequest request) {
        FileUploadBase.SizeLimitExceededException e = (FileUploadBase.SizeLimitExceededException)((Object)request.getAttribute(S2MultipartRequestHandler.SIZE_EXCEPTION_KEY));
        if (e != null) {
            ActionMessages errors = new ActionMessages();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.upload.size", new Object[]{e.getActualSize(), e.getPermittedSize()}));
            ActionMessagesUtil.addErrors(request, errors);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(String path, FormFile formFile) {
        if (formFile == null) return;
        if (formFile.getFileSize() == 0) {
            return;
        }
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            in = formFile.getInputStream();
            out = new BufferedOutputStream(new FileOutputStream(path));
            InputStreamUtil.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    InputStreamUtil.close((InputStream)in);
                    throw throwable;
                }
                finally {
                    OutputStreamUtil.close(out);
                }
            }
        }
        try {
            InputStreamUtil.close((InputStream)in);
            return;
        }
        finally {
            OutputStreamUtil.close((OutputStream)out);
        }
    }
}

