/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Processing;
import org.carrot2.output.metrics.IdealPartitioningBasedMetric;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable
public class ContaminationMetric
extends IdealPartitioningBasedMetric {
    public static final String CONTAMINATION = "contamination";
    @Processing
    @Output
    @Attribute
    public double weightedAverageContamination;
    @Processing
    @Input
    @Attribute
    public boolean enabled = true;
    @Processing
    @Input
    @Attribute(key="documents")
    public List<Document> documents;
    @Processing
    @Input
    @Attribute(key="clusters")
    public List<Cluster> clusters;

    @Override
    public void calculate() {
        int partitionCount = this.getPartitionsCount(this.documents);
        if (partitionCount == 0) {
            return;
        }
        int weightSum = 0;
        double contaminationSum = 0.0;
        for (Cluster cluster : this.clusters) {
            if (cluster.isOtherTopics()) continue;
            double contamination = this.calculate(cluster, partitionCount);
            cluster.setAttribute(CONTAMINATION, contamination);
            contaminationSum += contamination * (double)cluster.size();
            weightSum += cluster.size();
        }
        this.weightedAverageContamination = contaminationSum / (double)weightSum;
    }

    double calculate(Cluster cluster, int partitionCount) {
        int clusterPartitionAssignments = 0;
        for (Document document : cluster.getAllDocuments()) {
            clusterPartitionAssignments += ((Collection)document.getField("partitions")).size();
        }
        double worstCaseH = ContaminationMetric.calculateWorstCaseH(clusterPartitionAssignments, partitionCount);
        if (worstCaseH == 0.0) {
            return 0.0;
        }
        return (double)this.calculateH(cluster) / worstCaseH;
    }

    int calculateH(Cluster cluster) {
        Map<Object, Integer> documentCountByPartition = this.getDocumentCountByPartition(cluster.getAllDocuments());
        ArrayList counts = Lists.newArrayList();
        counts.addAll(documentCountByPartition.values());
        return ContaminationMetric.calculateH(counts);
    }

    static int calculateWorstCaseH(int clusterSize, int partitionCount) {
        ArrayList counts = Lists.newArrayList();
        for (int partition = 0; partition < partitionCount; ++partition) {
            counts.add(clusterSize / partitionCount + (partition < clusterSize % partitionCount ? 1 : 0));
        }
        return ContaminationMetric.calculateH(counts);
    }

    static int calculateH(ArrayList<Integer> counts) {
        int h = 0;
        for (int i = 0; i < counts.size() - 1; ++i) {
            for (int j = i + 1; j < counts.size(); ++j) {
                h += counts.get(i) * counts.get(j);
            }
        }
        return h;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

