/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.output.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.output.metrics.IdealPartitioningBasedMetricDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NormalizedMutualInformationMetricDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.output.metrics.NormalizedMutualInformationMetric";
    public final String prefix = "";
    public final String title = "Computes Normalized Mutual Information (NMI) metric for the cluster set";
    public final String label = "";
    public final String description = "<p> Metrics will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>. </p>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getTitle() {
        return "Computes Normalized Mutual Information (NMI) metric for the cluster set";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "<p> Metrics will be calculated only if all input documents have non-blank <code>Document.PARTITIONS</code>. </p>";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.normalizedMutualInformation);
        ownAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.documents);
        ownAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.clusters);
        ownAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.enabled);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.normalizedMutualInformation);
        allAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.documents);
        allAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.clusters);
        allAttrs.add(NormalizedMutualInformationMetricDescriptor.attributes.enabled);
        allAttrs.add(IdealPartitioningBasedMetricDescriptor.attributes.partitionIdFieldName);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends IdealPartitioningBasedMetricDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public Double normalizedMutualInformation() {
            return (Double)this.map.get("org.carrot2.output.metrics.NormalizedMutualInformationMetric.normalizedMutualInformation");
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public AttributeBuilder clusters(List<Cluster> value) {
            this.map.put("clusters", value);
            return this;
        }

        public AttributeBuilder enabled(boolean value) {
            this.map.put("org.carrot2.output.metrics.NormalizedMutualInformationMetric.enabled", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo normalizedMutualInformation = new AttributeInfo("org.carrot2.output.metrics.NormalizedMutualInformationMetric.normalizedMutualInformation", "org.carrot2.output.metrics.NormalizedMutualInformationMetric", "normalizedMutualInformation", "Normalized Mutual Information of the whole cluster set.", null, "Normalized Mutual Information of the whole cluster set", null, null, null, null);
        public final AttributeInfo documents = new AttributeInfo("documents", "org.carrot2.output.metrics.NormalizedMutualInformationMetric", "documents", null, null, null, null, null, null, null);
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.output.metrics.NormalizedMutualInformationMetric", "clusters", null, null, null, null, null, null, null);
        public final AttributeInfo enabled = new AttributeInfo("org.carrot2.output.metrics.NormalizedMutualInformationMetric.enabled", "org.carrot2.output.metrics.NormalizedMutualInformationMetric", "enabled", "Calculate Normalized Mutual Information metric.", null, "Calculate Normalized Mutual Information metric", null, null, null, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends IdealPartitioningBasedMetricDescriptor.Keys {
        public static final String NORMALIZED_MUTUAL_INFORMATION = "org.carrot2.output.metrics.NormalizedMutualInformationMetric.normalizedMutualInformation";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";
        public static final String ENABLED = "org.carrot2.output.metrics.NormalizedMutualInformationMetric.enabled";

        protected Keys() {
        }
    }
}

