/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.boss;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.boss.BossSearchServiceDescriptor;
import org.carrot2.source.boss.BossWebSearchService;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BossWebSearchServiceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.boss.BossWebSearchService";
    public final String prefix = "BossWebSearchService";
    public final String title = "Sends queries to Yahoo! Boss Web search service";
    public final String label = "Yahoo Boss Web Search Service";
    public final String description = "Instances of this class are thread-safe. <p> Attributes of this class correspond to Yahoo's documentation (see links below).";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "BossWebSearchService";
    }

    @Override
    public String getTitle() {
        return "Sends queries to Yahoo! Boss Web search service";
    }

    @Override
    public String getLabel() {
        return "Yahoo Boss Web Search Service";
    }

    @Override
    public String getDescription() {
        return "Instances of this class are thread-safe. <p> Attributes of this class correspond to Yahoo's documentation (see links below).";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(BossWebSearchServiceDescriptor.attributes.serviceURI);
        ownAttrs.add(BossWebSearchServiceDescriptor.attributes.filter);
        ownAttrs.add(BossWebSearchServiceDescriptor.attributes.type);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(BossWebSearchServiceDescriptor.attributes.serviceURI);
        allAttrs.add(BossWebSearchServiceDescriptor.attributes.filter);
        allAttrs.add(BossWebSearchServiceDescriptor.attributes.type);
        allAttrs.add(BossSearchServiceDescriptor.attributes.appid);
        allAttrs.add(BossSearchServiceDescriptor.attributes.sites);
        allAttrs.add(BossSearchServiceDescriptor.attributes.languageAndRegion);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends BossSearchServiceDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder serviceURI(String value) {
            this.map.put("BossWebSearchService.serviceURI", value);
            return this;
        }

        public AttributeBuilder filter(BossWebSearchService.OffensiveContentFilter value) {
            this.map.put("BossWebSearchService.filter", (Object)value);
            return this;
        }

        public AttributeBuilder filter(Class<? extends BossWebSearchService.OffensiveContentFilter> clazz) {
            this.map.put("BossWebSearchService.filter", clazz);
            return this;
        }

        public AttributeBuilder type(String value) {
            this.map.put("BossWebSearchService.type", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo serviceURI = new AttributeInfo("BossWebSearchService.serviceURI", "org.carrot2.source.boss.BossWebSearchService", "serviceURI", "Boss Web search service URI. Specifies the URI at which Yahoo Boss Web Search API\nis available. The <code>${query}</code> place holder will be replaced with the\nURL-encoded text of the processed query.", "Service URI", "Boss Web search service URI", "Specifies the URI at which Yahoo Boss Web Search API is available. The <code>${query}</code> place holder will be replaced with the URL-encoded text of the processed query.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo filter = new AttributeInfo("BossWebSearchService.filter", "org.carrot2.source.boss.BossWebSearchService", "filter", "Filters out adult or hate content. Must be a comma-separated list of content types\nto filter out.\n<p>\nThe following content types are supported:\n</p>\n<table>\n<thead>\n<tr>\n<th align=\"left\">Value</th> <th align=\"left\">Content</th>\n</tr>\n</thead> <tbody>\n<tr>\n<td><code>-porn</code></td>\n<td>Filters out adult content</td>\n</tr>\n<tr>\n<td><code>-hate</code></td>\n<td>Filters out hate content</td>\n</tr>\n</tbody>\n</table>\n<p>\nAdult content filtering is supported for all languages, hate content filtering is\nsupported for English only.\n</p>", "Content filter", "Filters out adult or hate content", "Must be a comma-separated list of content types to filter out. <p> The following content types are supported: </p> <table> <thead> <tr> <th align=\"left\">Value</th> <th align=\"left\">Content</th> </tr> </thead> <tbody> <tr> <td><code>-porn</code></td> <td>Filters out adult content</td> </tr> <tr> <td><code>-hate</code></td> <td>Filters out hate content</td> </tr> </tbody> </table> <p> Adult content filtering is supported for all languages, hate content filtering is supported for English only. </p>", "Results filtering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo type = new AttributeInfo("BossWebSearchService.type", "org.carrot2.source.boss.BossWebSearchService", "type", "Restricts search to documents of the specified types. Must be a comma-separated\nlist of the required document types or type groups.\n<p>\nThe following document types are supported:\n</p>\n<table>\n<thead>\n<tr>\n<th align=\"left\">Value</th> <th align=\"left\">Document type</th>\n</tr>\n</thead> <tbody>\n<tr>\n<td><code>html</code></td>\n<td>HTML documents</td>\n</tr>\n<tr>\n<td><code>text</code></td>\n<td>Plain text documents</td>\n</tr>\n<tr>\n<td><code>pdf</code></td>\n<td>Portable Document Format documents</td>\n</tr>\n<tr>\n<td><code>xl</code></td>\n<td>Microsoft Excel documents</td>\n</tr>\n<tr>\n<td><code>msword</code></td>\n<td>Microsoft Word documents</td>\n</tr>\n<tr>\n<td><code>ppt</code></td>\n<td>Microsoft Power Point documents</td>\n</tr>\n</tbody>\n</table>\n<p>\nThe following document type groups are supported:\n</p>\n<table>\n<thead>\n<tr>\n<th align=\"left\">Value</th> <th align=\"left\">Document type groups</th>\n</tr>\n</thead> <tbody>\n<tr>\n<td><code>msoffice</code></td>\n<td>All Microsoft Office documents (<code>xl</code>, <code>msword</code>,\n<code>ppt</code>)</td>\n</tr>\n<tr>\n<td><code>nohtml</code></td>\n<td>Anything else than HTML documents (<code>text</code>, <code>pdf</code>,\n<code>xl</code>, <code>msword</code>, <code>ppt</code>)</td>\n</tr>\n</tbody>\n</table>\n<p>\nYou can also specify a format group and then exclude an item:\n<code>type=msoffice,-ppt</code>.\n</p>", "Type filter", "Restricts search to documents of the specified types", "Must be a comma-separated list of the required document types or type groups. <p> The following document types are supported: </p> <table> <thead> <tr> <th align=\"left\">Value</th> <th align=\"left\">Document type</th> </tr> </thead> <tbody> <tr> <td><code>html</code></td> <td>HTML documents</td> </tr> <tr> <td><code>text</code></td> <td>Plain text documents</td> </tr> <tr> <td><code>pdf</code></td> <td>Portable Document Format documents</td> </tr> <tr> <td><code>xl</code></td> <td>Microsoft Excel documents</td> </tr> <tr> <td><code>msword</code></td> <td>Microsoft Word documents</td> </tr> <tr> <td><code>ppt</code></td> <td>Microsoft Power Point documents</td> </tr> </tbody> </table> <p> The following document type groups are supported: </p> <table> <thead> <tr> <th align=\"left\">Value</th> <th align=\"left\">Document type groups</th> </tr> </thead> <tbody> <tr> <td><code>msoffice</code></td> <td>All Microsoft Office documents (<code>xl</code>, <code>msword</code>, <code>ppt</code>)</td> </tr> <tr> <td><code>nohtml</code></td> <td>Anything else than HTML documents (<code>text</code>, <code>pdf</code>, <code>xl</code>, <code>msword</code>, <code>ppt</code>)</td> </tr> </tbody> </table> <p> You can also specify a format group and then exclude an item: <code>type=msoffice,-ppt</code>. </p>", "Results filtering", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends BossSearchServiceDescriptor.Keys {
        public static final String SERVICE_URI = "BossWebSearchService.serviceURI";
        public static final String FILTER = "BossWebSearchService.filter";
        public static final String TYPE = "BossWebSearchService.type";

        protected Keys() {
        }
    }
}

