/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.httpclient.HttpUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="GoogleDocumentSource")
public class GoogleDocumentSource
extends MultipageSearchEngine {
    public static final String CARROTSEARCH_API_KEY = "ABQIAAAA_XmITjrzoipJYoBApAgGJhS8yIvkL4-1sNwOJWkV7nbkjq_Z_BQW0-uzOh5lKXRtEXQDTGbzIEz06Q";
    @Input
    @Processing
    @Internal
    @Attribute
    public String serviceUrl = "http://ajax.googleapis.com/ajax/services/search/web";
    @Input
    @Processing
    @Internal
    @Attribute
    public String referer = "http://www.carrot2.org";
    @Input
    @Processing
    @Attribute
    public boolean keepHighlights = false;
    @Input
    @Processing
    @Internal
    @Attribute
    public String apiKey = "ABQIAAAA_XmITjrzoipJYoBApAgGJhS8yIvkL4-1sNwOJWkV7nbkjq_Z_BQW0-uzOh5lKXRtEXQDTGbzIEz06Q";
    static final MultipageSearchEngineMetadata metadata = new MultipageSearchEngineMetadata(8, 32);
    private static final int MAX_CONCURRENT_THREADS = 10;

    @Override
    public void process() throws ProcessingException {
        super.process(metadata, this.getSharedExecutor(10, this.getClass()));
    }

    @Override
    protected Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange bucket) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(){

            public SearchEngineResponse search() throws Exception {
                SearchEngineResponse response = new SearchEngineResponse();
                NameValuePair[] queryParams = new NameValuePair[]{new BasicNameValuePair("v", "1.0"), new BasicNameValuePair("rsz", "large"), new BasicNameValuePair("start", Integer.toString(bucket.start)), new BasicNameValuePair("key", GoogleDocumentSource.this.apiKey), new BasicNameValuePair("q", GoogleDocumentSource.this.query)};
                Header[] headers = new Header[]{new BasicHeader("Referer", GoogleDocumentSource.this.referer)};
                ObjectMapper mapper = new ObjectMapper();
                HttpUtils.Response httpResp = HttpUtils.doGET(GoogleDocumentSource.this.serviceUrl, Arrays.asList(queryParams), Arrays.asList(headers));
                JsonParser jsonParser = new JsonFactory().createJsonParser(httpResp.getPayloadAsStream());
                JsonNode root = mapper.readTree(jsonParser);
                if (root == null) {
                    return response;
                }
                JsonNode responseData = root.get("responseData");
                if (responseData == null) {
                    return response;
                }
                JsonNode resultsArray = responseData.get("results");
                if (resultsArray == null) {
                    return response;
                }
                Iterator results = resultsArray.getElements();
                while (results.hasNext()) {
                    JsonNode result = (JsonNode)results.next();
                    Document document = new Document(result.get("titleNoFormatting").getTextValue(), result.get("content").getTextValue(), result.get("url").getTextValue());
                    response.results.add(document);
                }
                JsonNode cursor = responseData.get("cursor");
                if (cursor == null) {
                    return response;
                }
                JsonNode resultCount = cursor.get("estimatedResultCount");
                if (resultCount != null) {
                    response.metadata.put("resultsTotal", Long.parseLong(resultCount.getTextValue()));
                } else {
                    response.metadata.put("resultsTotal", 0L);
                }
                response.metadata.put("compression", httpResp.compression);
                return response;
            }
        };
    }

    @Override
    protected void afterFetch(SearchEngineResponse response) {
        GoogleDocumentSource.clean(response, this.keepHighlights, "title", "snippet");
        for (Document document : response.results) {
            String url = (String)document.getField("url");
            if (url == null) continue;
            try {
                document.setField("url", URLDecoder.decode(url, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw ExceptionUtils.wrapAsRuntimeException(e);
            }
        }
    }
}

