/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static <T extends Throwable> T wrapAs(Class<T> clazz, Throwable t) {
        if (t == null) {
            return null;
        }
        if (clazz.isAssignableFrom(t.getClass())) {
            return (T)((Throwable)clazz.cast(t));
        }
        try {
            Class<?>[] params;
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                params = constructor.getParameterTypes();
                if (params.length != 1 || !params[0].isAssignableFrom(t.getClass())) continue;
                return (T)((Throwable)constructor.newInstance(t));
            }
            for (Constructor<?> constructor : constructors) {
                params = constructor.getParameterTypes();
                if (params.length != 1 || !params[0].isAssignableFrom(String.class)) continue;
                Throwable instance = (Throwable)constructor.newInstance(t.toString());
                instance.initCause(t);
                return (T)instance;
            }
            for (Constructor<?> constructor : constructors) {
                params = constructor.getParameterTypes();
                if (params.length != 0) continue;
                Throwable instance = (Throwable)constructor.newInstance(new Object[0]);
                instance.initCause(t);
                return (T)instance;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("(No constructor found in wrapper class " + clazz.getName() + "): ", t);
    }

    public static RuntimeException wrapAsRuntimeException(Throwable t) {
        return ExceptionUtils.wrapAs(RuntimeException.class, t);
    }

    public static String currentStackTrace() {
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        e.printStackTrace(pw);
        pw.flush();
        return w.toString();
    }
}

