/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.IsConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintFactory {
    public static List<Constraint> createConstraints(Annotation ... annotations) {
        ArrayList constraints = Lists.newArrayList();
        for (Annotation annotation : annotations) {
            if (!ConstraintFactory.isConstraintAnnotation(annotation.annotationType())) continue;
            constraints.add(ConstraintFactory.createImplementation(annotation));
        }
        return constraints;
    }

    static boolean isConstraintAnnotation(Class<? extends Annotation> ann) {
        return ann.isAnnotationPresent(IsConstraint.class);
    }

    static Constraint createImplementation(Annotation ann) {
        Constraint instance;
        IsConstraint constraintAnnotation = ann.annotationType().getAnnotation(IsConstraint.class);
        Class<?> implClass = constraintAnnotation.implementation();
        if (!Constraint.class.isAssignableFrom(implClass)) {
            throw new IllegalArgumentException("Implementation class " + implClass.getClass().getName() + " must implement " + Constraint.class.getName());
        }
        try {
            instance = (Constraint)implClass.newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsRuntimeException(e);
        }
        instance.populate(ann);
        return instance;
    }
}

