/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicInteger;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.IntRange;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persist;

@Root(name="int-range")
class IntRangeConstraint
extends Constraint {
    Integer min;
    Integer max;
    @Attribute(name="min", required=false)
    Integer minOrNull;
    @Attribute(name="max", required=false)
    Integer maxOrNull;

    IntRangeConstraint() {
    }

    protected boolean isMet(Object value) {
        if (value == null) {
            return false;
        }
        this.checkAssignableFrom(value, Byte.class, Short.class, Integer.class, AtomicInteger.class);
        Integer v = ((Number)value).intValue();
        return v >= this.min && v <= this.max;
    }

    public String toString() {
        return "range(min = " + this.min.toString() + ", max = " + this.max.toString() + ")";
    }

    public void populateCustom(Annotation annotation) {
        IntRange range = (IntRange)annotation;
        this.min = range.min();
        this.max = range.max();
    }

    @Persist
    void beforeSerialization() {
        if (this.min > Integer.MIN_VALUE) {
            this.minOrNull = this.min;
        }
        if (this.max < Integer.MAX_VALUE) {
            this.maxOrNull = this.max;
        }
    }
}

