/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;

public final class PrefixDecoratorLocator
implements IResourceLocator {
    private final IResourceLocator delegate;
    private final String prefix;

    public PrefixDecoratorLocator(IResourceLocator locator, String prefix) {
        if (locator == null) {
            throw new IllegalArgumentException("Delegate locator must not be null.");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null.");
        }
        this.delegate = locator;
        this.prefix = prefix;
    }

    public IResource[] getAll(String resource) {
        while (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        return this.delegate.getAll(this.prefix + resource);
    }

    public int hashCode() {
        return this.prefix.hashCode() ^ ((Object)this.delegate).hashCode();
    }

    public boolean equals(Object target) {
        if (target == this) {
            return true;
        }
        if (target != null && target instanceof PrefixDecoratorLocator) {
            PrefixDecoratorLocator other = (PrefixDecoratorLocator)target;
            return ((Object)this.delegate).equals(other.delegate) && this.prefix.equals(other.prefix);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [prefix: " + this.prefix + ", delegate: " + this.delegate + "]";
    }
}

