/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.XsltXMLLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltUpdateRequestHandler
extends ContentStreamHandlerBase {
    public static Logger log = LoggerFactory.getLogger(XsltUpdateRequestHandler.class);
    public static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static final String UPDATE_PROCESSOR = "update.processor";
    public static final int XSLT_CACHE_DEFAULT = 60;
    private static final String XSLT_CACHE_PARAM = "xsltCacheLifetimeSeconds";
    XMLInputFactory inputFactory;
    private Integer xsltCacheLifetimeSeconds;

    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input chain: " + this.inputFactory);
        }
        this.inputFactory.setXMLReporter((XMLReporter)xmllog);
        SolrParams p = SolrParams.toSolrParams((NamedList)args);
        this.xsltCacheLifetimeSeconds = p.getInt(XSLT_CACHE_PARAM, 60);
        log.info("xsltCacheLifetimeSeconds=" + this.xsltCacheLifetimeSeconds);
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new XsltXMLLoader(processor, this.inputFactory, this.xsltCacheLifetimeSeconds);
    }

    public String getDescription() {
        return "Add documents with XML, transforming with XSLT first";
    }

    public String getVersion() {
        return "$Revision: 1142003 $";
    }

    public String getSourceId() {
        return "$Id: XsltUpdateRequestHandler.java 1142003 2011-07-01 17:37:17Z uschindler $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_6/solr/core/src/java/org/apache/solr/handler/XsltUpdateRequestHandler.java $";
    }
}

