package Base::Session::Cookie;
# -------------------------------------------------------------------------
# Base::Session::Cookie
#
# - Base::Session::xxx  Cookie 󥿥եͿ
#
#
# -------------------------------------------------------------------------
use strict;
use vars qw(@ISA);
@ISA = qw(Base::Session);
use Base::Session;

use Carp;
use CGI::Cookie;
use POSIX qw(strftime);

# -------------------------------------------------------------------------
# new
# - STORE ꤵ줿 Base::Sesstion::xxxx Ѿ
#
# -------------------------------------------------------------------------
sub new {
	my $class = shift;
	my (%option) = @_;

	my $self  = bless {%option}, $class;
	my $store = "Base::Session::$self->{STORE}";
	eval "require $store" || croak $@;
	push(@ISA, $store);

	return $self;
}

# -------------------------------------------------------------------------
# åο
# - å˥ǡåIDȤ¸
#
# -------------------------------------------------------------------------
sub create {
	my $class = shift;

	my $self = (ref $class eq "")? $class->new() : $class;

	#
	# åǡκ
	#
	$self->SUPER::create();


	#
	# Cookieκ
	#
	$self->set_cookie();

	return $self;
}

# -------------------------------------------------------------------------
# åɤ߹ 
# - åIDϥå
# - ȤγǧԤ
#
# -------------------------------------------------------------------------
sub open {
	my $class = shift;

	my $self = (ref $class eq "")? $class->new() : $class;

	#
	# å饻åIDȤ
	#
	my %cookie = CGI::Cookie->fetch;
	my $cookie_key = $self->{COOKIE_KEY};
	exists $cookie{$cookie_key} or croak "Cookie not found: $cookie_key";

	my %cookie_data = $cookie{$cookie_key}->value;
	my $sid    = $cookie_data{sid};
	my $digest = $cookie_data{digest};


	#
	# åǡɤ߹
	#
	$self->SUPER::open($sid);


	#
	# Ȥ
	#
	$self->is_digest($digest) or croak "digest check failed: $digest";


	#
	# Cookieͭ¤αĹ
	#
	$self->set_cookie();

	return $self;
}

# -------------------------------------------------------------------------
# å¸
# - å˥åIDȥȤ¸
#
# -------------------------------------------------------------------------
sub set_cookie {
	my $self = shift;

	#
	# åͭ¤ ѷ RFC1123
	# http://home.netscape.com/newsref/std/cookie_spec.html
	#
	my $expire_time = $self->get('_expire');
	my $expire = strftime "%a, %d-%b-%Y %H:%M:%S GMT", gmtime($expire_time);

	#
	# å˥åIDȤ¸
	#
	my $cookie = CGI::Cookie->new(
		-name  => $self->{COOKIE_KEY},
		-value => {
			sid    => $self->id,
			digest => $self->digest,
		},
		($self->{EXPIRE} > 0)? (-expires => $expire) : "",
	);

	print "Set-Cookie: $cookie\n";
}

1;
