package FFFF::Module::csv;
# --------------------------------------------------------------------
# FFFF::Module::csv 
# - CSVǡ¸
#
#
# --------------------------------------------------------------------
use strict;
use POSIX qw(strftime);
$FFFF::Module::csv::TIME = time();


require "jcode.pl";

# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#           FILE => '/home/ta/{TIME:%Y_%m}.cvs',
#           SAVE => [
#                       '{TIME:%Y-%m-%d %H:%M:%S}',
#                       'id',
#                       'name',
#                       'kana',
#                       'email',
#                       '{FROM:zip1}-{FORM:zip2}',
#                       '{ENV:HTTP_USER_AGENT}',
#                       '{ENV:REMOTE_HOST}'
#                     ],
#           SEPARATE     => 'TAB'
#           CHAR_SET     => 'EUC-JP',
#           DELETE_BREAK => 1
# }
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# ¸
	#
	$config{SAVE} = [map{@$_} map{@$_} $config->{save}];
	
	#
	# إå
	#
	if (ref $config->{header} eq "ARRAY") {
		$config{HEADER} = [map{@$_} map{@$_} $config->{header}];
	}

	#
	# ¸ե
	#
	$config{FILE} = $config->{file}->[0]->[0];

	#
	# ¸
	#
	$config{SEPARATE} = ($config->{separate}->[0]->[0] =~ /^tab$/i)? 'TAB' : "";

	#
	# ¸ʸ
	#
	$config{CHAR_SET} = $config->{charset}->[0]->[0] || 'Shift_JIS';
	

	#
	# ԥ(LF, CF)̵뤹뤫ɤ
	# ǥե:On
	#
	$config{DELETE_BREAK} = $config->{deletebreak}->[0]->[0];
	$config{DELETE_BREAK} = ($config{DELETE_BREAK} =~ /^Off$/i)? 0 : 1;

	return \%config;
}

# --------------------------------------------------------------------
# execute
# - ͤƥեCSV¸
#
# --------------------------------------------------------------------
sub execute {
	my $self     = shift;
	my ($config) = @_;

	#
	# å󤫤ǡ
	#
	my %session = $self->session_data();

	#
	# ե̾
	#
	my $file = $config->{FILE};
	$file =~ s/{FORM:(.+?)}/$session{$1}/g;
	$file =~ s/{(\w+):(.+)}/$self->FFFF::Module::csv::filter($1, $2)/eg;

	#
	# ¸ܤμ
	#
	my @save = map {@$_} $config->{SAVE};
	for my $save (@save) {
		#
		# եफ
		#
		if ($save =~ /^(\w+)$/) {
			$save = $session{$1};
		}

		#
		# ե륿
		#
		else {
			$save =~ s/{FORM:(.+?)}/$session{$1}/g;
			$save =~ s/{(\w+):(.*?)}/$self->FFFF::Module::csv::filter($1, $2)/eg;
		}
	}

	#
	# ʸ
	#
	if ($config->{DELETE_BREAK} == 1) {
		for (@save) { s/\n|\r//g; }
	}


	#
	# ¸ʸ
	# ϡ˿ʽФĤʤ餳դϳ٤
	# Perl 5.8 ǥݡȤ Encode ⥸塼Ȥ٤?
	#
	my $char_set;
	if ($config->{CHAR_SET} =~ /^Shift_JIS$/) {
		$char_set = 'sjis';
	}
	elsif ($config->{CHAR_SET} =~ /^EUC-JP$/) {
		$char_set = 'euc';
	}
	elsif ($config->{CHAR_SET} =~ /^ISO-2022-JP$/) {
		$char_set = 'jis';
	}


	#
	# ¸
	#
	open(CSV, ">>$file") or die "Can't Open file : $file";
	flock(CSV, 2) or die "Can't File Lock";
	seek(CSV, 0, 2);

	#
	# ե뤬 0 ХȤǥإåƤإå
	#
	if ((stat CSV)[7] == 0 and ref $config->{HEADER} eq "ARRAY") {
		my $header;
		if ($config->{SEPARATE} eq 'TAB') {
			$header = join "\t", map {@$_} $config->{HEADER};
		}
		else {
			$header = join ",", map {@$_} $config->{HEADER};
		}
		
		$header = jcode::to($char_set, $header, "euc");
		print CSV "$header\n";
	}

	#
	# TABڤѴƥե¸
	#
	my $line;
	if ($config->{SEPARATE} eq 'TAB') {
		$line = join "\t", map {s/\t//g; $_} @save;
	}

	#
	# CSVѴƥե¸
	# http://www.din.or.jp/~ohzaki/perl.htm#CSVfromValues
	#
	else {
		$line = join ",", map {(s/"/""/g or /[\r\n,]/)? qq{"$_"} : $_} @save;
	}

	$line = jcode::to($char_set, $line, "euc");
	print CSV "$line\n";

	flock(CSV, 8);
	close(CSV);
}

# --------------------------------------------------------------------
# ե륿
#
# --------------------------------------------------------------------
sub filter {
	my $self     = shift;
	my ($filter_name, $value) = @_;

	my $func = "FFFF::Module::csv::filter_${filter_name}";

	return $self->$func($value);
}

sub filter_ENV {
	my $self  = shift;
	my ($key) = @_;

	return $ENV{$key};
}

sub filter_TIME {
	my $self  = shift;
	my ($format) = @_;

	#
	# Solaris  %s бƤʤк
	#
	$format =~ s/\%s/$FFFF::Module::csv::TIME/g;

	return strftime($format, localtime($FFFF::Module::csv::TIME));
}

sub filter_STR {
	my $self  = shift;
	my ($value) = @_;

	return  $value;
}

1;
__END__
=head CHANGES
0.0.3   2002/05/15
	- ʸɤλб
"CharSet  EUC-JP" ͤ˻ꤷޤ
	- strftime  %s(1970ΥեåáSolarisбƤʤΤ
	  б

0.0.2   2002/05/14
	- Header ꤷƤʤȥ顼ˤʤХ
	- TABڤб
	  "Separate  Tab" ͤ˻ꤷޤ

0.0.1   2002/05/09
	- original version
=cut

