<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans
 */
/**
 * @file BeanComponentFactory.php
 * @brief BeanComponentFactory.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: BeanComponentFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
require_once "ficus/lang/AutoLoad.php";
require_once "ficus/lang/S2ContainerAutoLoad.php";
require_once "ficus/lang/ClassLoaderAutoLoad.php";
require_once "ficus/lang/ClassPath.php";
require_once "ficus/test/PathInitializer.php";

/**
 * @class Ficus_BeanComponentFactory
 */
class Ficus_BeanComponentFactory
{
    const CONTEXT_BUILD = "mock";
    const CONTEXT_DEPLOY = "deploy";
    
    /**
     * @var $context string context
     */
    private static $context = Ficus_BeanComponentFactory::CONTEXT_DEPLOY;

    /**
     * @var $cache array cache
     */
    private static $cache = array();
    
    /**
     * @var S2Container container.
     */
    private $container = null;

    /**
     * @var Soya_ComponentFactory self.
     */
    private static $factory = null;

    /**
     * Constructor.
     */
    private function __construct() {
        $confDir = Ficus_ClassPath::get(Ficus_PathInitializer::CONF_PATH);
        $confDir = $confDir->paths();
        $confDir = $confDir[0];
        if(defined('SOYA_DICON_PATH') == false){
            define(SOYA_DICON_PATH, $confDir);
        }
        if(self::$context === self::CONTEXT_DEPLOY){
            $diconPath = $confDir . "soya.dicon";
        }else if(self::$context === self::CONTEXT_BUILD){
            $diconPath = $confDir . "mock.dicon";
        }
        
        $this->container = S2ContainerFactory::create($diconPath);
    }

    /**
     * set context and reset factory
     *
     * @param $context string build or deploy
     */
    public static function setContext($context){
        if(self::$context !== $context){
            self::$context = $context;
            self::$factory = null;
        }
    }

    /**
     * Get factory.
     *
     * @param $context string context
     * @return S2Container container.
     */
    public static function getContainer($context = null) {
        if (self::$factory === null ||
           ($context !== null) && self::$context !== $context) {
            Ficus_AutoLoad::add(new Ficus_S2ContainerAutoLoad());
            Ficus_AutoLoad::add(new Ficus_ClassLoaderAutoLoad());
            self::$factory = new Ficus_BeanComponentFactory();
        }
        return self::$factory->container;
    }

    /**
     * Get component.
     *
     * @param $name string component name.
     * @return mixed component.
     */
    public static function getComponent($name) {
        $container = self::getContainer();
        return $container->getComponent($name);
    }
}
?>
