<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file ArrayBeanDeserializer.php
 * @brief deserialize Array to Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ArrayBeanDeserializer.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/Bean.php";
require_once "ficus/beans/BeanManager.php";
require_once "ficus/beans/annotation/BeanAnnotationAccessor.php";
require_once "ficus/beans/serializer/BeanDeserializer.php";
require_once "ficus/exception/IllegalBeanException.php";
require_once "ficus/lang/Assert.php";
require_once "ficus/lang/reflect/ReflectionClass.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationProperty.php";
require_once "ficus/lang/reflect/annotation/ReflectionAnnotationClass.php";

/**
 * @class Ficus_ArrayBeanDeserializer
 */
class Ficus_ArrayBeanDeserializer implements Soya_BeanDeserializer{

    /**
     * @var $manager Ficus_BeanManager manager
     */
    private $manager = null;
    
    /**
     * serialize bean to RDF
     * @param $data array array to deserialize
     * @param $bean Ficus_Bean target bean
     * @return Ficus_Bean bean
     */
    public function deserialize($bean, $data){
        $this->manager = new Ficus_BeanManager();
        $bean = $this->parseArray($bean, $data);
        return $bean;
    }

    /**
     * Deserialize Array to Bean
     * @param $bean Ficus_Bean bean to parse
     * @param $data Array array to parse
     * @return Ficus_Bean result bean
     * @throw Ficus_IllegalBeanException illegal bean.
     */
    private function parseArray($bean, $data){
        if($data instanceof stdClass){
            $data = (array)$data;
        }

        $accessor = Ficus_BeanAnnotationAccessor::getAccessor($bean);
        $properties = $accessor->getPropertyAnnotations();
        foreach($properties as $property){
            $setter = "set" . ucfirst($property->getName());
            if(array_key_exists($property->getName(), $data) == false){
                continue;
            }
                
            $contents = $data[$property->getName()];
            if($property->isArray()){
                $bean->{$setter}($contents);
            }else if($property->isLiteral()){
                $bean->{$setter}(trim($contents));
            }else{
                $type = $property->getType();
                $propBean = $this->manager->search($type);
                $propBean = $this->parseArray($propBean, $contents);
                $bean->{$setter}($propBean);
            }
        }
        return $bean;
    }
}
?>
