<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.crypto
 */
/**
 * @file Cipher.php
 * @brief cipher class
 * @author <a href="mailto:"></a>
 * @version $Id: Cipher.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * cipher class
 */

require_once "ficus/crypto/Key.php";
require_once "ficus/crypto/CryptoConstants.php";
require_once "ficus/lang/ClassLoader.php";
require_once "ficus/exception/AlgorithmNotFoundException.php";

/**
 * @class Ficus_Cipher
 */
abstract class Ficus_Cipher implements Ficus_CryptoConstants
{
    const SIGNATURE = "ficus.crypto.Ficus_%sCipher";

    /**
     * get instance
     * @param $algorithm string algorithm
     * @return Ficus_Cipher instance
     */
    public static function getInstance($algorithm){
        $classname = sprintf(self::SIGNATURE, $algorithm);
        try{
            $cipher = Ficus_ClassLoader::load($classname);
            return $cipher;
        }catch(Exception $e){
            throw new Ficus_AlgorithmNotFoundException($e->getMessage(), $e);
        }
    }

    /**
     * crypt data with key
     * @param $data string data to crypt
     * @param $key Ficus_Key to use cryption
     * @return crypted data
     */
    public abstract function encrypt($data, $key);

    /**
     * decrypt data from crypted data.
     * @param $data string crypted data
     * @param $key Ficus_Key to use decrypt
     * @return decripted data
     */
    public abstract function decrypt($data, $key);
}
?>
